 // Misja w nadprzestrzeń C++14/17, program z paragrafu 3.1


#include <iostream>
using namespace std;
/////////////////////////////////////////////////////////////////////////////////////////
void funkcja_latwiejsza(int wart) noexcept(true) 	// obiecuje, że nie rzuca wyjątku 		// `1
{
	cout << "Pracuje " << __func__ << " " << wart << endl;
	return;
}
//*******************************************************************
void funkcja_zwykla(int wart) noexcept(false)	// czyli w sprawie wyjątków nie obiecuje nic 	// `2
{
	cout << "Pracuje " << __func__ << " argument: " << wart << endl;

	if(wart >100) throw std::runtime_error("za duza wartosc argumentu");			// `3
	cout << "Ta wartosc jest OK" << endl;
	return;
}
//*******************************************************************
int main()
{
	// A) definiujemy wskaźnik mogący wskazywać na funkcje,
	// 					które obiecują: "nie rzucam żadnych wyjątków"
	void (* wskf_uproszcz_obsluga )(int wart)	noexcept(true) ; 					// `4

	wskf_uproszcz_obsluga = funkcja_latwiejsza; 							// `5
	wskf_uproszcz_obsluga(1); // wywołanie funkcji								// `6

	// wskf_uproszcz_obsluga = funkcja_zwykla; // w C++17 tak przypisać nie można! 	// `7

	// B) definiujemy wskaźnik mogący wskazywać na funkcje zwykłe -------
	void (*wskf_uniwersalny)(int wart) noexcept(false); 							// `8
	wskf_uniwersalny = funkcja_zwykla;									// `9

	try {
		wskf_uniwersalny(400); 											// `10
	}
	catch(std::runtime_error e)
	{
		cout << "Zlapany wyjatek runtime_error: " << e.what() << endl;
	}

	wskf_uniwersalny = funkcja_latwiejsza; 	// tak przypisać wolno 				// `11
	wskf_uniwersalny(40);					// wywołanie wskazywanej funkcji
}
// `@
