package eu.sig.training.r04.v2;

import eu.sig.training.r04.BusinessException;
import eu.sig.training.r04.Money;

// tag::SavingsAccount[]
public class SavingsAccount {
    CheckingAccount registeredCounterAccount;

    public Transfer makeTransfer(String counterAccount, Money amount) 
        throws BusinessException {
        // 1. Sprawdzenie poprawności 9-cyfrowego numeru konta
        // przy użyciu mechanizmu modulo-11
        if (Accounts.isValid(counterAccount)) { // <1>
            // 2. Wyszukanie konta docelowego i utworzenie obiektu przelewu
            CheckingAccount acct = Accounts.findAcctByNumber(counterAccount);
            Transfer result = new Transfer(this, acct, amount); // <2>
            if (result.getCounterAccount().equals(this.registeredCounterAccount)) 
            {
                return result;
            } else {
                throw new BusinessException("Konto rozliczeniowe niezarejestrowane!!!");
            }
        } else {
            throw new BusinessException("Nieprawidłowy numer konta!!!");
        }
    }

}
// end::SavingsAccount[]
