package eu.sig.training.r04.v1;

import eu.sig.training.r04.BusinessException;
import eu.sig.training.r04.Money;

// tag::CheckingAccount[]
public class CheckingAccount {
    private int transferLimit = 100;

    public Transfer makeTransfer(String counterAccount, Money amount)
        throws BusinessException {
        // 1. Sprawdzenie limitu wypłat
        if (amount.greaterThan(this.transferLimit)) {
            throw new BusinessException("Limit przekroczony!!!");
        }
        // 2. Zakładając, że wynik jest 9-cyfrowym numerem konta bankowego, sprawdzenie go przy użyciu algorytmu modulo 11
        int sum = 0;
        for (int i = 0; i < counterAccount.length(); i++) {
            sum = sum + (9-i) * Character.getNumericValue(
                counterAccount.charAt(i));
        }
        if (sum % 11 == 0) {
            // 3. Wyszukanie konta docelowego i utworzenie obiektu przelewu
            CheckingAccount acct = Accounts.findAcctByNumber(counterAccount);
            Transfer result = new Transfer(this, acct, amount);
            return result;
        } else {
            throw new BusinessException("Nieprawidłowy numer konta!!!");
        }
    }
}
// end::CheckingAccount[]
