package eu.sig.training.r03;

import static eu.sig.training.r03.JenkinsUser.LOGGER.Level.FINE;
import static eu.sig.training.r03.JenkinsUser.XmlFile.XSTREAM;

import java.io.File;
import java.io.IOException;

import eu.sig.training.r03.JenkinsUser.LOGGER.Level;

@SuppressWarnings("unused")
public class JenkinsUser {

    // tag::getOrCreate[]
    /**
	 * Pobranie użytkownika wg jego ID i utworzenie nowego, jeśli jest taka potrzeba.
	 * @return
	 *    Istniejący lub utworzony użytkownik. Może być {@code null}, jeśli
	 *    użytkownik nie istnieje i {@code create} ma wartość false.
	 */

    private static User getOrCreate(String id, String fullName,
        boolean create) {
        String idkey = idStrategy().keyFor(id);

        byNameLock.readLock().lock();
        User u;
        try {
            u = byName.get(idkey);
        } finally {
            byNameLock.readLock().unlock();
        }
        final File configFile = getConfigFileFor(id);
        if (!configFile.isFile() && !configFile.getParentFile().isDirectory()) {
            // sprawdzenie starszych użytkowników i migracja, jeśli jest to bezpieczne
            File[] legacy = getLegacyConfigFilesFor(id);
            if (legacy != null && legacy.length > 0) {
                for (File legacyUserDir : legacy) {
                    final XmlFile legacyXml = new XmlFile(XSTREAM,
                        new File(legacyUserDir, "config.xml"));
                    try {
                        Object o = legacyXml.read();
                        if (o instanceof User) {
                            if (idStrategy().equals(id, legacyUserDir.getName())
                                && !idStrategy()
                                    .filenameOf(legacyUserDir.getName())
                                    .equals(legacyUserDir.getName())) {
                                if (!legacyUserDir
                                    .renameTo(configFile.getParentFile())) {
                                    LOGGER.log(Level.WARNING,
                                        "Nieudana migracja rekordu użytkownika " +
                                        "od {0} do {1}",
                                        new Object[] {legacyUserDir,
                                            configFile.getParentFile()});
                                }
                                break;
                            }
                        } else {
                            LOGGER.log(FINE,
                                "Nieoczekiwany obiekt ładowany z {0}: {1}",
                                new Object[] {legacyUserDir, o});
                        }
                    } catch (IOException e) {
                        LOGGER.log(Level.FINE,
                            String.format(
                                "Wyjątek podczas próby ładowania użytkownika z {0}: {1}",
                                new Object[] {legacyUserDir, e.getMessage()}),
                            e);
                    }
                }
            }
        }
        if (u == null && (create || configFile.exists())) {
            User tmp = new User(id, fullName);
            User prev;
            byNameLock.readLock().lock();
            try {
                prev = byName.putIfAbsent(idkey, u = tmp);
            } finally {
                byNameLock.readLock().unlock();
            }
            if (prev != null) {
                u = prev; // użycie wartości, jeśli ktoś umieścił ją już w tablicy
                if (LOGGER.isLoggable(Level.FINE)
                    && !fullName.equals(prev.getFullName())) {
                    LOGGER.log(Level.FINE,
                        "niezgodność fullName (‘" + fullName + "’ z ‘"
                            + prev.getFullName() + "’) dla ‘" + id + "’",
                        new Throwable());
                }
            } else
                if (!id.equals(fullName) && !configFile.exists()) {
                // JENKINS-16332: ponieważ fullName może nie dać się odtworzyć 
                // z identyfikatora, a różne części kodu mogą przechowywać tylko identyfikator,
                // należy zapisać fullName
                try {
                    u.save();
                } catch (IOException x) {
                    LOGGER.log(Level.WARNING, null, x);
                }
            }
        }
        return u;
    }
    // end::getOrCreate[]

    public static class User {
        public User(Object... o) {}

        public void save() throws IOException {}

        public Object getFullName() {
            return null;
        }
    }

    public static class XmlFile {
        public static final Object XSTREAM = new Object();

        public XmlFile(Object... o) {}

        public Object read() throws IOException {
            return null;
        }
    }

    public static class LOGGER {
        public static enum Level {
            FINE, WARNING
        }

        public static void log(Object... o) {}

        public static boolean isLoggable(Level fine) {
            return false;
        }
    }

    public static class Strategy {
        public String keyFor(String id) {
            return null;
        }

        public boolean equals(String id, String name) {
            return false;
        }

        public Object filenameOf(String name) {
            return null;
        }
    }

    public static Strategy idStrategy() {
        return new Strategy();
    }

    public static class Lock {
        public Lock readLock() {
            return null;
        }

        public void lock() {}

        public void unlock() {}

        public User putIfAbsent(String idkey, User user) {
            return null;
        }

        public User get(String idkey) {
            return null;
        }
    }

    private static Lock byName = new Lock();

    private static Lock byNameLock = new Lock();

    private static File[] getLegacyConfigFilesFor(String id) {
        return null;
    }

    private static File getConfigFileFor(String id) {
        return null;
    }

}
