//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <string>
#include "GL/glew.h"
#include "text.h"
#ifdef WIN32
#include <GL/wglext.h>
#else
#define GLX_GLXEXT_PROTOTYPES
#include <GL/glx.h>
#include <GL/glxext.h>
#endif // WIN32
#include "glenum_map.h"

//////////////////////////////////////////////////////////////////////
// klasa obsugujca funkcj glGetStringi
//////////////////////////////////////////////////////////////////////
class glGetStringiClass
{
protected:
    // wskanik
    PFNGLGETSTRINGIPROC glGetStringiPtr;

    // parmetry funkcji glGetStringi
    GLenum name;
    GLuint index;

    // nazwa parametru names
    std::string nameStr;

    // pobranie wskanika
    void GetPtr()
    {
        if( !glGetStringiPtr )
#ifdef WIN32
            glGetStringiPtr = reinterpret_cast < PFNGLGETSTRINGIPROC > ( wglGetProcAddress( "glGetStringi" ) );
#else
            glGetStringiPtr = reinterpret_cast < PFNGLGETSTRINGIPROC > ( glXGetProcAddress( (GLubyte *)"glGetStringi" ) );
#endif // WIN32
    }

public:
    // konstruktor
    glGetStringiClass(): glGetStringiPtr( NULL ), name( 0 ), index( 0 ) {}

    // operator funkcyjny
    const GLubyte *operator()( GLenum name, GLuint index )
    {
        // wartoci parametrw
        glGetStringiClass::name = name;
        glGetStringiClass::index = index;

        // nazwa parametru name
        if( GLenumMap.find( name ) != GLenumMap.end() )
            nameStr = GLenumMap[name];

        // sprawdzenie dostpnoci wskanika i wywoanie funkcji
        if( !glGetStringiPtr ) GetPtr();
        if( glGetStringiPtr )
            return glGetStringi( name, index );

        // bd - brak wskanika
        throw;
    }
};

//////////////////////////////////////////////////////////////////////
// funkcja glGetStringi
//////////////////////////////////////////////////////////////////////
#undef glGetStringi
glGetStringiClass glGetStringi;

//////////////////////////////////////////////////////////////////////
// pobranie numeru wersji biblioteki OpenGL
// numer wersji pomnoony przez 10
//////////////////////////////////////////////////////////////////////
int OpenGLVersion()
{
    // pobranie numeru wersji OpenGL
    int major = 0, minor = 0;
    glGetIntegerv( GL_MAJOR_VERSION, &major );
    glGetIntegerv( GL_MINOR_VERSION, &minor );
    return 10*major + minor;
}

//////////////////////////////////////////////////////////////////////
// funkcja generujca scen 3D
//////////////////////////////////////////////////////////////////////
void DisplayScene()
{
    // czyszczenie bufora koloru
    glClear( GL_COLOR_BUFFER_BIT );

    // rozmiary okna renderingu
    GLint viewport[4];
    glGetIntegerv( GL_VIEWPORT, viewport );
    GLuint width = viewport[2];
    GLuint height = viewport[3] - 16;

    // autor implementacji OpenGL, OpenGL 1.0
    std::string str = "GL_VENDOR: ";
    str += reinterpret_cast<const char*>( glGetString( GL_VENDOR ) );
    DrawText8x16( 0, height, str );
    height -= 16;

    // nazwa urzdzenia renderujcego, OpenGL 1.0
    str = "GL_RENDERER: ";
    str += reinterpret_cast<const char*>( glGetString( GL_RENDERER ) );
    DrawText8x16( 0, height, str );
    height -= 16;

    // numer wersji implementacji OpenGL, OpenGL 1.0
    str = "GL_VERSION: ";
    str += reinterpret_cast<const char*>( glGetString( GL_VERSION ) );
    DrawText8x16( 0, height, str );
    height -= 16;

    // numer wersji obsugiwanego jzyka GLSL, OpenGL 2.0
    str = "GL_SHADING_LANGUAGE_VERSION: ";
    str += reinterpret_cast<const char*>( glGetString( GL_SHADING_LANGUAGE_VERSION ) );
    const GLubyte *glsl = glGetStringi( GL_SHADING_LANGUAGE_VERSION, 0 );
    if( glsl )
    {
        str += " / ";
        str += reinterpret_cast<const char*>( glsl );
    }
    else
        glGetError();
    DrawText8x16( 0, height, str );
    height -= 16;

    // kontekst renderingu, OpenGL 3.0
    if( OpenGLVersion() >= 30 )
    {
        GLint context;
        glGetIntegerv( GL_CONTEXT_FLAGS, &context );
        if( context & GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT )
        {
            DrawText8x16( 0, height, "GL_CONTEXT_FLAGS: GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT" );
            height -= 16;
        }
    }

    // profile kontekstu renderingu, OpenGL 3.2
    if( OpenGLVersion() >= 32 )
    {
        GLint profile;
        glGetIntegerv( GL_CONTEXT_PROFILE_MASK, &profile );
        if( profile & GL_CONTEXT_CORE_PROFILE_BIT )
        {
            DrawText8x16( 0, height, "GL_CONTEXT_PROFILE_MASK: GL_CONTEXT_CORE_PROFILE_BIT" );
            height -= 16;
        }
        else
        if( profile & GL_CONTEXT_COMPATIBILITY_PROFILE_BIT )
        {
            DrawText8x16( 0, height, "GL_CONTEXT_PROFILE_MASK: GL_CONTEXT_COMPATIBILITY_PROFILE_BIT" );
            height -= 16;
        }
    }

    // lista obsugiwanych rozszerze OpenGL, OpenGL 3.0
    str = "GL_EXTENSIONS: ";
    GLint numExt;
    glGetIntegerv( GL_NUM_EXTENSIONS, &numExt );
    for( int i = 0; i < numExt; i++ )
    {
        std::string ext( reinterpret_cast<const char*>( glGetStringi( GL_EXTENSIONS, i ) ) );
        if( 8 * (str.length() + ext.length()) < width )
        {
            str += ext + " ";
        }
        else
        {
            DrawText8x16( 0, height, str );
            height -= 16;
            str = "  " + ext + " ";
        }
    }

    // wywietlenie ostatniego cigu znakw
    if( str.length() )
    {
        DrawText8x16( 0, height, str );
        height -= 16;
    }
}

//////////////////////////////////////////////////////////////////////
// zmiana wielkoci okna
//////////////////////////////////////////////////////////////////////
void Reshape( int width, int height )
{
    // obszar renderingu - cae okno
    glViewport( 0, 0, width, height );
}

//////////////////////////////////////////////////////////////////////
// inicjalizacja staych elementw maszyny stanu OpenGL
//////////////////////////////////////////////////////////////////////
void InitScene()
{
    // kolor ta - zawarto bufora koloru
    glClearColor( 1.0f, 1.0f, 1.0f, 1.0f );

    // wczenie mechanizmw uywanych podczas renderingu tekstu
    InitDrawText();
}

//////////////////////////////////////////////////////////////////////
// usunicie obiektw OpenGL
//////////////////////////////////////////////////////////////////////
void DeleteScene()
{
    // usunicie mechanizmw uywanych podczas renderingu tekstu
    DeleteDrawText();
}

