//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>
#include <glm/vec4.hpp>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// nazwa pliku podana w wierszu polecenia
//////////////////////////////////////////////////////////////////////
extern char *fileName;

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat left;
extern GLfloat right;
extern GLfloat bottom;
extern GLfloat top;
extern GLfloat scale;
extern GLfloat rotateX;
extern GLfloat rotateY;
extern GLfloat translateX;
extern GLfloat translateZ;
enum
{
    CUBEMAP_MASKONAIVE,
    CUBEMAP_TEIDE,
    CUBEMAP_TENERIFE,
    CUBEMAP_VASA
};
extern int texNumber;
extern GLfloat modelRotateX;
extern GLfloat modelRotateY;
extern bool reverseHeightMap;
extern GLfloat eta;

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// pooenie kursora myszy
//////////////////////////////////////////////////////////////////////
int buttonX, buttonY;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // zapamitanie pooenia kursora myszy
        if( state == GLUT_DOWN )
        {
            buttonX = x;
            buttonY = y;
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        rotateY += 30 *(right - left) / glutGet( GLUT_WINDOW_WIDTH ) * (x - buttonX);
        buttonX = x;
        rotateX -= 30 *(top - bottom) / glutGet( GLUT_WINDOW_HEIGHT ) * (buttonY - y);
        buttonY = y;
        glutPostRedisplay();
    }
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // znacznik odwrcenia wartoci mapy wysokoci
    REVERSE_HEIGHT_MAP_TRUE = 20,
    REVERSE_HEIGHT_MAP_FALSE,

    EXIT   // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // rodzaj tekstury
        case CUBEMAP_MASKONAIVE:
        case CUBEMAP_TEIDE:
        case CUBEMAP_TENERIFE:
        case CUBEMAP_VASA:
            texNumber = value - CUBEMAP_MASKONAIVE;
            break;

        // znacznik odwrcenia wartoci mapy wysokoci
        case REVERSE_HEIGHT_MAP_TRUE:
            reverseHeightMap = true;
            break;
        case REVERSE_HEIGHT_MAP_FALSE:
            reverseHeightMap = false;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // 1
        case '1':
            texNumber = CUBEMAP_MASKONAIVE;
            break;
        // 2
        case '2':
            texNumber = CUBEMAP_TEIDE;
            break;
        // 3
        case '3':
            texNumber = CUBEMAP_TENERIFE;
            break;
        // 4
        case '4':
            texNumber = CUBEMAP_VASA;
            break;

        // a
        case 'A':
        case 'a':
            translateX += 0.1f;
            break;
        // w
        case 'W':
        case 'w':
            translateZ += 0.1f;
            break;
        // s
        case 'S':
        case 's':
            translateZ -= 0.1f;
            break;
        // d
        case 'D':
        case 'd':
            translateX -= 0.1f;
            break;

        // klawisz +
        case '+':
            scale += 0.03f;
            break;
        // klawisz -
        case '-':
            if( scale > 0.03f ) scale -= 0.03f;
            break;

        // f
        case 'F':
        case 'f':
            eta += 0.01f;
            break;
        // g
        case 'G':
        case 'g':
            if( eta > 0.02f ) eta -= 0.01f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiszy funkcyjnych i klawiszy kursora
//////////////////////////////////////////////////////////////////////
void SpecialKeys( int key, int x, int y )
{
    switch( key )
    {
        // kursor w lewo
        case GLUT_KEY_LEFT:
            modelRotateY -= 1.0f;
            break;

        // kursor w gr
        case GLUT_KEY_UP:
            modelRotateX -= 1.0f;
            break;

        // kursor w prawo
        case GLUT_KEY_RIGHT:
            modelRotateY += 1.0f;
            break;

        // kursor w d
        case GLUT_KEY_DOWN:
            modelRotateX += 1.0f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // pobranie nazwy pliku do wywietlenia
    fileName = argv[1];

    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 4, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
    glutCreateWindow( "Dyspersja" );

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_4_3 )
    {
        std::cout << "Brak OpenGL 4.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu - Odwrcenie mapy wysokoci
    int menuReverseHeightMap = glutCreateMenu( Menu );
    glutAddMenuEntry( "wlaczone", REVERSE_HEIGHT_MAP_TRUE );
    glutAddMenuEntry( "wylaczone", REVERSE_HEIGHT_MAP_FALSE );

    // utworzenie podmenu - Tekstura
    int menuTexture = glutCreateMenu( Menu );
    glutAddMenuEntry( "Maskonaive", CUBEMAP_MASKONAIVE );
    glutAddMenuEntry( "Teide", CUBEMAP_TEIDE );
    glutAddMenuEntry( "Tenerife", CUBEMAP_TENERIFE );
    glutAddMenuEntry( "Vasa", CUBEMAP_VASA );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddSubMenu( "Odwrocenie mapy wysokosci", menuReverseHeightMap );
    glutAddSubMenu( "Tekstura", menuTexture );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // obsuga klawiszy funkcyjnych i klawiszy kursora
    glutSpecialFunc( SpecialKeys );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
