//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// wektory przesuni poszczeglnych instancji obiektu
//////////////////////////////////////////////////////////////////////
uniform vec4 positions[4];

//////////////////////////////////////////////////////////////////////
// nuery materiaw poszczeglnych instancji obiektu
//////////////////////////////////////////////////////////////////////
uniform int materials[4];

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0
#define NORMAL 1

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
layout( location = NORMAL ) in vec3 inNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
out vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
out vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// numer materiau obiektu
//////////////////////////////////////////////////////////////////////
flat out int material;

void main()
{
    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * (inPosition + positions[gl_InstanceID]);

    // wsprzdne wierzchoka do interpolacji
    inoutPosition = (inPosition + positions[gl_InstanceID]).xyz;

    // wsprzdne wektora normalnego do interpolacji
    inoutNormal = inNormal;

    // numer materiau obiektu
    material = materials[gl_InstanceID];
}
