//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// dodatkowy wektor skalowania (odbicia) wsprzdnych wektora
// normalnego (wsprzdne wierzchokw s skalowane przez macierz
// modelu-widoku)
//////////////////////////////////////////////////////////////////////
uniform vec3 addScale;

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0
#define NORMAL 1

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
layout( location = NORMAL ) in vec3 inNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
out vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
out vec3 inoutNormal;

void main()
{
    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * inPosition;

    // wsprzdne wierzchoka do interpolacji
    inoutPosition = inPosition.xyz;

    // wsprzdne wektora normalnego do interpolacji
    inoutNormal = inNormal * addScale;
}
