//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern int texNumber;
extern GLuint baseLevel;

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // rodzaj tekstury
    TEXTURE_MIPMAP_LOAD,
    TEXTURE_MIPMAP_GEN,

    // poziomy obrazu (mipmapy)
    MIPMAP_LEVEL_0,
    MIPMAP_LEVEL_1,
    MIPMAP_LEVEL_2,
    MIPMAP_LEVEL_3,
    MIPMAP_LEVEL_4,
    MIPMAP_LEVEL_5,
    MIPMAP_LEVEL_6,
    MIPMAP_LEVEL_7,
    MIPMAP_LEVEL_8,
    MIPMAP_LEVEL_9,

    EXIT    // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // rodzaj tekstury
        case TEXTURE_MIPMAP_LOAD:
        case TEXTURE_MIPMAP_GEN:
            texNumber = value;
            break;

        // poziomy obrazu (mipmapy)
        case MIPMAP_LEVEL_0:
        case MIPMAP_LEVEL_1:
        case MIPMAP_LEVEL_2:
        case MIPMAP_LEVEL_3:
        case MIPMAP_LEVEL_4:
        case MIPMAP_LEVEL_5:
        case MIPMAP_LEVEL_6:
        case MIPMAP_LEVEL_7:
        case MIPMAP_LEVEL_8:
        case MIPMAP_LEVEL_9:
            baseLevel = value - MIPMAP_LEVEL_0;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // 1
        case '1':
            texNumber = TEXTURE_MIPMAP_LOAD;
            break;
        // 2
        case '2':
            texNumber = TEXTURE_MIPMAP_GEN;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiszy funkcyjnych i klawiszy kursora
//////////////////////////////////////////////////////////////////////
void SpecialKeys( int key, int x, int y )
{
    switch( key )
    {
        // nastpny poziom obrazu
        case GLUT_KEY_PAGE_DOWN:
            if( baseLevel < 9 )
                baseLevel++;
            break;
        // poprzedni poziom obrazu
        case GLUT_KEY_PAGE_UP:
            if( baseLevel > 0 )
                baseLevel--;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 3, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
    glutCreateWindow( "Mipmapy 2D" );

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_3_3 )
    {
        std::cout << "Brak OpenGL 3.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu - Bazowy poziom obrazu (mipmapy)
    int menuBaseLevel = glutCreateMenu( Menu );
    glutAddMenuEntry( "poziom 0 (512512)", MIPMAP_LEVEL_0 );
    glutAddMenuEntry( "poziom 1 (256256)", MIPMAP_LEVEL_1 );
    glutAddMenuEntry( "poziom 2 (128128)", MIPMAP_LEVEL_2 );
    glutAddMenuEntry( "poziom 3 (6464)", MIPMAP_LEVEL_3 );
    glutAddMenuEntry( "poziom 4 (3232)", MIPMAP_LEVEL_4 );
    glutAddMenuEntry( "poziom 5 (1616)", MIPMAP_LEVEL_5 );
    glutAddMenuEntry( "poziom 6 (88)", MIPMAP_LEVEL_6 );
    glutAddMenuEntry( "poziom 7 (44)", MIPMAP_LEVEL_7 );
    glutAddMenuEntry( "poziom 8 (22)", MIPMAP_LEVEL_8 );
    glutAddMenuEntry( "poziom 9 (11)", MIPMAP_LEVEL_9 );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddMenuEntry( "Mipmapy zaladowane z pliku", TEXTURE_MIPMAP_LOAD );
    glutAddMenuEntry( "Mipmapy generowane automatycznie", TEXTURE_MIPMAP_GEN );
    glutAddSubMenu( "Bazowy poziom obrazu (mipmapy)", menuBaseLevel );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // obsuga klawiszy funkcyjnych i klawiszy kursora
    glutSpecialFunc( SpecialKeys );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
