//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION  0
#define NORMAL    1
#define TEX_COORD 2
#define TANGENT   3
#define BITANGENT 4

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
layout( location = NORMAL ) in vec3 inNormal;

//////////////////////////////////////////////////////////////////////
// wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
layout( location = TEX_COORD ) in vec2 inTexCoord;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora stycznego
//////////////////////////////////////////////////////////////////////
layout( location = TANGENT ) in vec3 inTangent;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora bistycznego
//////////////////////////////////////////////////////////////////////
layout( location = BITANGENT ) in vec3 inBitangent;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
out vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
out vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora stycznego
//////////////////////////////////////////////////////////////////////
out vec3 inoutTangent;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora bistycznego
//////////////////////////////////////////////////////////////////////
out vec3 inoutBitangent;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
out vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * inPosition;

    // wsprzdne wierzchoka do interpolacji
    inoutPosition = inPosition.xyz;

    // wsprzdne wektora normalnego do interpolacji
    inoutNormal = inNormal;

    // wsprzdne wektora stycznego do interpolacji
    inoutTangent = inTangent;

    // wsprzdne wektora bistycznego do interpolacji
    inoutBitangent = inBitangent;

    // wsprzdne tekstury do interpolacji
    inoutTexCoord = inTexCoord;
}
