//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// liczba warstw renderingu
//////////////////////////////////////////////////////////////////////
const int FRAME_LAYERS = 16;

//////////////////////////////////////////////////////////////////////
// tablica tekstur 2D
//////////////////////////////////////////////////////////////////////
uniform sampler2DArray tex;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // pocztkowy kolor fragmentu
    outColor = vec4( 0.0 );

    // przetwarzanie kolejnych warstw tablicy tekstur
    for( int layer = 0; layer < FRAME_LAYERS; layer++ )
    {
        outColor += (FRAME_LAYERS - layer) * texture( tex, vec3( inoutTexCoord, layer ) );
    }

    // normalizacja wartoci skadowych koloru fragmentu
    outColor /= outColor.a;
}
