//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// uchwyt tablicy tekstur 2D
//////////////////////////////////////////////////////////////////////
uniform sampler2DArray tex;

//////////////////////////////////////////////////////////////////////
// znacznik mieszania tekseli
//////////////////////////////////////////////////////////////////////
uniform bool lerp;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec3 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // obliczenie wsprzdnych tekstury z uwzgldnieniem
    // odpowiedniej warstwy w tablicy tekstur
    vec3 coord = vec3( inoutTexCoord.st, floor( inoutTexCoord.p ) );

    // mieszanie tekseli wczone
    if( lerp )
    {
        // skadowe tekseli pierwszej z dwch ssiednich warstw tablicy tekstur
        vec4 color0 = texture( tex, coord );

        // obliczenie numeru warstwy nastpnej tekstury; przyjmujemy,
        // e dla ostatniej warstwy nastpn jest pierwsza warstwa
        if( coord.p >= 3.0 )
            coord.p = 0.0;
        else
            coord.p += 1.0;

        // skadowe tekseli drugiej z dwch ssiednich warstw tablicy tekstur
        vec4 color1 = texture( tex, coord );

        // cz uamkowa interpolowanej wsprzdnej p
        // ze wspczynnikiem mieszania warstw tekstury
        float frac = fract( inoutTexCoord.p );

        // liniowa interpolacja skadowych tekseli dwch warstw tekstury
        outColor = mix( color0, color1, frac );
    }
    else
        // mieszanie tekseli wyczone - standardowe prbkowanie tekstury
        outColor = texture( tex, coord );
}
