//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// rozmiar punktu
//////////////////////////////////////////////////////////////////////
uniform float pointSize;

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION  0

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka i numer patka niegu
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// numer tekstury patka niegu
//////////////////////////////////////////////////////////////////////
flat out float snowFlake;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // standardowe przeksztacenie wierzchokw
    gl_Position = modelViewProjectionMatrix * vec4( inPosition.xyz, 1.0 );

    // numer tekstury patka niegu
    snowFlake = inPosition.w;

    // wielko punktu modulowana przez warto
    // trzeciej wsprzdnej jego pooenia
    gl_PointSize = 1.2*(pointSize + 2.0*inPosition.z);
}
