//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// uchwyt tekstury 2D
//////////////////////////////////////////////////////////////////////
uniform sampler2D tex;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // prbkowanie tekstury
    vec4 color = texture( tex, inoutTexCoord );

    // rekonstrukcja skadowej B przy zaoeniu,
    // e skadowe RGB tworz wektor jednostkowy
    // przed operacj wartoci skadowych RG trzeba
    // przeksztaci z przedziau <0;1> do <-1;1>
    vec2 rg = 2.0 * color.rg - 1.0;
    color.b = 0.5 * (sqrt( 1.0 - dot( rg, rg ) ) + 1.0);

    // kolor wyjciowy
    outColor = color;
}
