//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern int filterType;

//////////////////////////////////////////////////////////////////////
// nazwa pliku podana w wierszu polecenia
//////////////////////////////////////////////////////////////////////
extern char *fileName;

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    NEUTRAL_FILTER,                 // filtr neutralny
    AVERAGE_FILTER,                 // filtr uredniajcy
    LP1_FILTER,                     // filtr LP1
    LP2_FILTER,                     // filtr LP2
    LP3_FILTER,                     // filtr LP3
    GAUSS_FILTER,                   // filtr Gaussa
    MEAN_REMOVAL_FILTER,            // filtr usuwajcy redni
    HP1_FILTER,                     // filtr HP1
    HP2_FILTER,                     // filtr HP2
    HP3_FILTER,                     // filtr HP3
    HORIZONTAL_FILTER,              // filtr poziomy
    VERTICAL_FILTER,                // filtr pionowy
    HORIZONTAL_VERTICAL_FILTER,     // filtr poziomy/pionowy
    GRADIENT_EAST_FILTER,           // filtr gradientowy wschd
    GRADIENT_SOUTH_EAST_FILTER,     // filtr gradientowy poudniowy wschd
    GRADIENT_SOUTH_FILTER,          // filtr gradientowy poudnie
    GRADIENT_SOUTH_WEST_FILTER,     // filtr gradientowy poudniowy zachd
    GRADIENT_WEST_FILTER,           // filtr gradientowy zachd
    GRADIENT_NORTH_WEST_FILTER,     // filtr gradientowy pnocny zachd
    GRADIENT_NORTH_FILTER,          // filtr gradientowy pnoc
    GRADIENT_NORTH_EAST_FILTER,     // filtr gradientowy pnocny wschd
    EMBOSS_EAST_FILTER,             // filtr uwypuklajcy wschd
    EMBOSS_SOUTH_EAST_FILTER,       // filtr uwypuklajcy poudniowy wschd
    EMBOSS_SOUTH_FILTER,            // filtr uwypuklajcy poudnie
    EMBOSS_SOUTH_WEST_FILTER,       // filtr uwypuklajcy poudniowy zachd
    EMBOSS_WEST_FILTER,             // filtr uwypuklajcy zachd
    EMBOSS_NORTH_WEST_FILTER,       // filtr uwypuklajcy pnocny zachd
    EMBOSS_NORTH_FILTER,            // filtr uwypuklajcy pnoc
    EMBOSS_NORTH_EAST_FILTER,       // filtr uwypuklajcy pnocny wschd
    LAPLACIAN_LAPL1_FILTER,         // filtr Laplace'a LAPL1
    LAPLACIAN_LAPL2_FILTER,         // filtr Laplace'a LAPL2
    LAPLACIAN_LAPL3_FILTER,         // filtr Laplace'a LAPL3
    LAPLACIAN_DIAGONAL_FILTER,      // filtr Laplace'a skony
    LAPLACIAN_HORIZONTAL_FILTER,    // filtr Laplace'a poziomy
    LAPLACIAN_VERTICAL_FILTER,      // filtr Laplace'a pionowy
    SOBEL_HORIZONTAL_FILTER,        // filtr poziomy Sobela
    SOBEL_VERTICAL_FILTER,          // filtr pionowy Sobela
    PREWITT_HORIZONTAL_FILTER,      // filtr poziomy Prewitta
    PREWITT_VERTICAL_FILTER,        // filtr pionowy Prewitta

    EXIT    // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        case NEUTRAL_FILTER:                 // filtr neutralny
        case AVERAGE_FILTER:                 // filtr uredniajcy
        case LP1_FILTER:                     // filtr LP1
        case LP2_FILTER:                     // filtr LP2
        case LP3_FILTER:                     // filtr LP3
        case GAUSS_FILTER:                   // filtr Gaussa
        case MEAN_REMOVAL_FILTER:            // filtr usuwajcy redni
        case HP1_FILTER:                     // filtr HP1
        case HP2_FILTER:                     // filtr HP2
        case HP3_FILTER:                     // filtr HP3
        case HORIZONTAL_FILTER:              // filtr poziomy
        case VERTICAL_FILTER:                // filtr pionowy
        case HORIZONTAL_VERTICAL_FILTER:     // filtr poziomy/pionowy
        case GRADIENT_EAST_FILTER:           // filtr gradientowy wschd
        case GRADIENT_SOUTH_EAST_FILTER:     // filtr gradientowy poudniowy wschd
        case GRADIENT_SOUTH_FILTER:          // filtr gradientowy poudnie
        case GRADIENT_SOUTH_WEST_FILTER:     // filtr gradientowy poudniowy zachd
        case GRADIENT_WEST_FILTER:           // filtr gradientowy zachd
        case GRADIENT_NORTH_WEST_FILTER:     // filtr gradientowy pnocny zachd
        case GRADIENT_NORTH_FILTER:          // filtr gradientowy pnoc
        case GRADIENT_NORTH_EAST_FILTER:     // filtr gradientowy pnocny wschd
        case EMBOSS_EAST_FILTER:             // filtr uwypuklajcy wschd
        case EMBOSS_SOUTH_EAST_FILTER:       // filtr uwypuklajcy poudniowy wschd
        case EMBOSS_SOUTH_FILTER:            // filtr uwypuklajcy poudnie
        case EMBOSS_SOUTH_WEST_FILTER:       // filtr uwypuklajcy poudniowy zachd
        case EMBOSS_WEST_FILTER:             // filtr uwypuklajcy zachd
        case EMBOSS_NORTH_WEST_FILTER:       // filtr uwypuklajcy pnocny zachd
        case EMBOSS_NORTH_FILTER:            // filtr uwypuklajcy pnoc
        case EMBOSS_NORTH_EAST_FILTER:       // filtr uwypuklajcy pnocny wschd
        case LAPLACIAN_LAPL1_FILTER:         // filtr Laplace'a LAPL1
        case LAPLACIAN_LAPL2_FILTER:         // filtr Laplace'a LAPL2
        case LAPLACIAN_LAPL3_FILTER:         // filtr Laplace'a LAPL3
        case LAPLACIAN_DIAGONAL_FILTER:      // filtr Laplace'a skony
        case LAPLACIAN_HORIZONTAL_FILTER:    // filtr Laplace'a poziomy
        case LAPLACIAN_VERTICAL_FILTER:      // filtr Laplace'a pionowy
        case SOBEL_HORIZONTAL_FILTER:        // filtr poziomy Sobela
        case SOBEL_VERTICAL_FILTER:          // filtr pionowy Sobela
        case PREWITT_HORIZONTAL_FILTER:      // filtr poziomy Prewitta
        case PREWITT_VERTICAL_FILTER:        // filtr pionowy Prewitta
            filterType = value;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // pobranie nazwy pliku do wywietlenia
    fileName = argv[1];

    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 3, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
#ifdef WIN32
    glutCreateWindow( "Filtracja obrazw" );
#else
    glutCreateWindow( "Filtracja obrazow" );
#endif // WIN32

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_3_3 )
    {
        std::cout << "Brak OpenGL 3.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu - Filtr 33
    int menuFilter3x3 = glutCreateMenu( Menu );
    glutAddMenuEntry( "filtr neutralny", NEUTRAL_FILTER );
    glutAddMenuEntry( "filtr usredniajacy", AVERAGE_FILTER );
    glutAddMenuEntry( "filtr LP1", LP1_FILTER );
    glutAddMenuEntry( "filtr LP2", LP2_FILTER );
    glutAddMenuEntry( "filtr LP3", LP3_FILTER );
    glutAddMenuEntry( "filtr Gaussa", GAUSS_FILTER );
    glutAddMenuEntry( "filtr usuwajscy srednia", MEAN_REMOVAL_FILTER );
    glutAddMenuEntry( "filtr HP1", HP1_FILTER );
    glutAddMenuEntry( "filtr HP2", HP2_FILTER );
    glutAddMenuEntry( "filtr HP3", HP3_FILTER );
    glutAddMenuEntry( "filtr poziomy", HORIZONTAL_FILTER );
    glutAddMenuEntry( "filtr pionowy", VERTICAL_FILTER );
    glutAddMenuEntry( "filtr poziomy/pionowy", HORIZONTAL_VERTICAL_FILTER );
    glutAddMenuEntry( "filtr gradientowy wschod", GRADIENT_EAST_FILTER );
    glutAddMenuEntry( "filtr gradientowy poludniowy wschod", GRADIENT_SOUTH_EAST_FILTER );
    glutAddMenuEntry( "filtr gradientowy poludnie", GRADIENT_SOUTH_FILTER );
    glutAddMenuEntry( "filtr gradientowy poludniowy zachod", GRADIENT_SOUTH_WEST_FILTER );
    glutAddMenuEntry( "filtr gradientowy zachod", GRADIENT_WEST_FILTER );
    glutAddMenuEntry( "filtr gradientowy polnocny zachod", GRADIENT_NORTH_WEST_FILTER );
    glutAddMenuEntry( "filtr gradientowy polnoc", GRADIENT_NORTH_FILTER );
    glutAddMenuEntry( "filtr gradientowy polnocny wschod", GRADIENT_NORTH_EAST_FILTER );
    glutAddMenuEntry( "filtr uwypuklajacy wschod", EMBOSS_EAST_FILTER );
    glutAddMenuEntry( "filtr uwypuklajacy poludniowy wschod", EMBOSS_SOUTH_EAST_FILTER );
    glutAddMenuEntry( "filtr uwypuklajacy poludnie", EMBOSS_SOUTH_FILTER );
    glutAddMenuEntry( "filtr uwypuklajacy poludniowy zachod", EMBOSS_SOUTH_WEST_FILTER );
    glutAddMenuEntry( "filtr uwypuklajacy zachod", EMBOSS_WEST_FILTER );
    glutAddMenuEntry( "filtr uwypuklajacy polnocny zachod", EMBOSS_NORTH_WEST_FILTER );
    glutAddMenuEntry( "filtr uwypuklajacy polnoc", EMBOSS_NORTH_FILTER );
    glutAddMenuEntry( "filtr uwypuklajacy polnocny wschod", EMBOSS_NORTH_EAST_FILTER );
    glutAddMenuEntry( "filtr Laplace'a LAPL1", LAPLACIAN_LAPL1_FILTER );
    glutAddMenuEntry( "filtr Laplace'a LAPL2", LAPLACIAN_LAPL2_FILTER );
    glutAddMenuEntry( "filtr Laplace'a LAPL3", LAPLACIAN_LAPL3_FILTER );
    glutAddMenuEntry( "filtr Laplace'a skosny", LAPLACIAN_DIAGONAL_FILTER );
    glutAddMenuEntry( "filtr Laplace'a poziomy", LAPLACIAN_HORIZONTAL_FILTER );
    glutAddMenuEntry( "filtr Laplace'a pionowy", LAPLACIAN_VERTICAL_FILTER );
    glutAddMenuEntry( "filtr poziomy Sobela", SOBEL_HORIZONTAL_FILTER );
    glutAddMenuEntry( "filtr pionowy Sobela", SOBEL_VERTICAL_FILTER );
    glutAddMenuEntry( "filtr poziomy Prewitta", PREWITT_HORIZONTAL_FILTER );
    glutAddMenuEntry( "filtr pionowy Prewitta", PREWITT_VERTICAL_FILTER );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddSubMenu( "Filtr 33", menuFilter3x3 );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
