//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.30
//////////////////////////////////////////////////////////////////////
#version 430

//////////////////////////////////////////////////////////////////////
// parametry teselacji
//////////////////////////////////////////////////////////////////////
layout( triangles, equal_spacing, ccw ) in;

//////////////////////////////////////////////////////////////////////
// definicje numerw pooenia zmiennych jednorodnych
// i powizania uchwytw tekstur
//////////////////////////////////////////////////////////////////////
#define AMBIENT     0
#define DIFFUSE     1
#define SPECULAR    2
#define SHININESS   3
#define HEIGHT      4
#define NORMAL      5
#define TEXTURE_LOC 4

//////////////////////////////////////////////////////////////////////
// tablica znacznikw materiaw zawartych w teksturze
//////////////////////////////////////////////////////////////////////
layout( location = TEXTURE_LOC ) uniform bool textures[6] =
        bool[6]( false, false, false, false, false, false );

//////////////////////////////////////////////////////////////////////
// uchwyt tekstury 2D
// mapa wysokoci
//////////////////////////////////////////////////////////////////////
layout( binding = HEIGHT ) uniform sampler2D texHeight;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// wspczynnik skalowania wielkoci przemieszczenia
//////////////////////////////////////////////////////////////////////
uniform float displacement;

//////////////////////////////////////////////////////////////////////
// znacznik odwrcenia wartoci mapy wysokoci
//////////////////////////////////////////////////////////////////////
uniform bool reverseHeightMap;

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;

    // wsprzdne wektora stycznego
    vec3 tangent;

    // wsprzdne wektora bistycznego
    vec3 bitangent;

    // wsprzdne tekstury
    vec2 texCoord;
} In[];

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
out vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
out vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora stycznego
//////////////////////////////////////////////////////////////////////
out vec3 inoutTangent;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wektora bistycznego
//////////////////////////////////////////////////////////////////////
out vec3 inoutBitangent;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
out vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // wsprzdne barycentryczne wierzchoka prymitywu
    float u = gl_TessCoord[0];
    float v = gl_TessCoord[1];
    float w = gl_TessCoord[2];   // w = 1 - u - v;

    // interpolacja liniowa wsprzdnych wierzchoka
    inoutPosition = u * In[0].position.xyz + v * In[1].position.xyz + w * In[2].position.xyz;

    // interpolacja liniowa wektora normalnego
    inoutNormal = normalize( u * In[0].normal + v * In[1].normal + w * In[2].normal );

    // interpolacja liniowa wsprzdnych tekstury
    inoutTexCoord = u * In[0].texCoord + v * In[1].texCoord + w * In[2].texCoord;

    // interpolacja liniowa wektora stycznego
    inoutTangent = normalize( u * In[0].tangent + v * In[1].tangent + w * In[2].tangent );

    // interpolacja liniowa wektora bistycznego
    inoutBitangent = normalize( u * In[0].bitangent + v * In[1].bitangent + w * In[2].bitangent );

    // test dostpnoci mapy wysokoci
    if( textures[HEIGHT] )
    {
        // wysoko punktu powierzchni
        float height = reverseHeightMap ? 2.0 * (1.0 - texture2D( texHeight, inoutTexCoord ).x) - 1.0 :
                                          2.0 * texture2D( texHeight, inoutTexCoord ).x - 1.0;

        // przemieszczenie wierzchoka wzgldem wektora normalnego powierzchni
        inoutPosition += displacement * height * inoutNormal;
    }

    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * vec4( inoutPosition, 1.0 );
}
