//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.20
//////////////////////////////////////////////////////////////////////
#version 420

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// pooenie rda wiata
//////////////////////////////////////////////////////////////////////
uniform vec4 lightPosition;

//////////////////////////////////////////////////////////////////////
// prymityw wejciowy
//////////////////////////////////////////////////////////////////////
layout( triangles_adjacency ) in;

//////////////////////////////////////////////////////////////////////
// prymityw wyjciowy, maksymalna liczba generowanych wierzchokw
//////////////////////////////////////////////////////////////////////
layout( triangle_strip, max_vertices = 18 ) out;

//////////////////////////////////////////////////////////////////////
// wierzchoki trjkta podstawowego
//////////////////////////////////////////////////////////////////////
#define V0 gl_in[0].gl_Position.xyz
#define V2 gl_in[2].gl_Position.xyz
#define V4 gl_in[4].gl_Position.xyz

//////////////////////////////////////////////////////////////////////
// wierzchoki trjktw przylegych
//////////////////////////////////////////////////////////////////////
#define V1 gl_in[1].gl_Position.xyz
#define V3 gl_in[3].gl_Position.xyz
#define V5 gl_in[5].gl_Position.xyz

//////////////////////////////////////////////////////////////////////
// generowanie czworokta - powierzchni bocznej bryy cienia
// v0, v1 - wierzchoki krawdzi trjkta rozpinajcej czworokt
//////////////////////////////////////////////////////////////////////
void EmitQuad( const vec3 v0, const vec3 v1 )
{
    // generujemy cztery wierzchoki - dwa trjkty
    gl_Position = modelViewProjectionMatrix * vec4( v0, 1.0 );
    EmitVertex();
    gl_Position = modelViewProjectionMatrix * vec4( lightPosition.w * v0 - lightPosition.xyz, 0.0 );
    EmitVertex();
    gl_Position = modelViewProjectionMatrix * vec4( v1, 1.0 );
    EmitVertex();
    gl_Position = modelViewProjectionMatrix * vec4( lightPosition.w * v1 - lightPosition.xyz, 0.0 );
    EmitVertex();
    EndPrimitive();
}

//////////////////////////////////////////////////////////////////////
// generowanie przedniego domknicia bryy cienia
// v0, v1, v2 - wierzchoki trjkta tworzce domknicie
//////////////////////////////////////////////////////////////////////
void EmitFrontCap( const vec3 v0, const vec3 v1, const vec3 v2 )
{
    gl_Position = modelViewProjectionMatrix * vec4( v0, 1.0 );
    EmitVertex();
    gl_Position = modelViewProjectionMatrix * vec4( v1, 1.0 );
    EmitVertex();
    gl_Position = modelViewProjectionMatrix * vec4( v2, 1.0 );
    EmitVertex();
    EndPrimitive();
}

//////////////////////////////////////////////////////////////////////
// generowanie tylnego domknicia bryy cienia
// v0, v1, v2 - wierzchoki trjkta tworzce domknicie
//////////////////////////////////////////////////////////////////////
void EmitBackCap( const vec3 v0, const vec3 v1, const vec3 v2 )
{
    gl_Position = modelViewProjectionMatrix * vec4( lightPosition.w * v0 - lightPosition.xyz, 0.0 );
    EmitVertex();
    gl_Position = modelViewProjectionMatrix * vec4( lightPosition.w * v1 - lightPosition.xyz, 0.0 );
    EmitVertex();
    gl_Position = modelViewProjectionMatrix * vec4( lightPosition.w * v2 - lightPosition.xyz, 0.0 );
    EmitVertex();
    EndPrimitive();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main ()
{
    // obliczenie wektora normalnego trjkta podstawowego
    const vec3 N024 = normalize( cross( V0 - V2, V0 - V4 ) );

    // dalsze operacje wykonujemy wycznie na cianach obiektu
    // widocznych z punktu widzenia rda wiata
    if( dot( normalize( lightPosition.w * V0 - lightPosition.xyz ), N024 ) > 0.0 )
    {
        // generowanie przedniego i tylnego domknicia bryy cienia
        EmitFrontCap( V0, V2, V4 );
        EmitBackCap( V0, V4, V2 );

        // sprawdzamy, czy trjkty przylege s widoczne z punktu
        // widzenia rda wiata; jeeli nie, to krawd podstawowa
        // wchodzca w skad trjkta przylegego jest krawdzi brzegow
        // i w takim przypadku generujemy bry cienia (dwa trjkty)

        // trjkt przylegy V0, V1, V2
        const vec3 N012 = normalize( cross ( V0 - V1, V0 - V2 ) );
        if( dot( normalize( lightPosition.w * V0 - lightPosition.xyz ), N012 ) < 0.0 )
        {
            EmitQuad( V0, V2 );
        }

        // trjkt przylegy V2, V3, V4
        const vec3 N234 = normalize( cross( V2 - V3, V2 - V4 ) );
        if( dot( normalize( lightPosition.w * V2 - lightPosition.xyz ), N234 ) < 0.0 )
        {
            EmitQuad( V2, V4 );
        }

        // trjkt przylegy V4, V5, V0
        const vec3 N450 = normalize( cross( V4 - V5, V4 - V0 ) );
        if( dot( normalize( lightPosition.w * V4 - lightPosition.xyz ), N450 ) < 0.0 )
        {
            EmitQuad( V4, V0 );
        }
    }
}
