//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// parametry teselacji
//////////////////////////////////////////////////////////////////////
layout( triangles, equal_spacing, ccw ) in;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// stopie "puszystoci" powierzchni
//////////////////////////////////////////////////////////////////////
uniform float alpha = 0.75f;

//////////////////////////////////////////////////////////////////////
// blok zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} In[];

//////////////////////////////////////////////////////////////////////
// blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec3 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} Out;

//////////////////////////////////////////////////////////////////////
// zmienne wejciowe okrelone na pat wierzchokw
//////////////////////////////////////////////////////////////////////
patch in vec3 termIJ;
patch in vec3 termJK;
patch in vec3 termIK;

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchokw trjkta
//////////////////////////////////////////////////////////////////////
#define Pi In[0].position.xyz
#define Pj In[1].position.xyz
#define Pk In[2].position.xyz

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // wsprzdne barycentryczne wierzchoka prymitywu
    float u = gl_TessCoord[0];
    float v = gl_TessCoord[1];
    float w = gl_TessCoord[2];   // w = 1 - u - v;

    // pooenie wierzchoka
    Out.position = (1.0 - alpha) * ( u * Pi + v * Pj + w * Pk ) + 
                   alpha * (u * u * Pi + v * v * Pj + w * w * Pk +
                   u * v * termIJ + v * w * termJK + w * u * termIK );

    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * vec4( Out.position, 1.0 );

    // interpolacja liniowa wektora normalnego
    Out.normal = normalize( u * In[0].normal + v * In[1].normal + w * In[2].normal );
}
