//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// parametry teselacji
//////////////////////////////////////////////////////////////////////
layout( triangles, equal_spacing, ccw ) in;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// blok zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} In[];

//////////////////////////////////////////////////////////////////////
// zmienne wejciowe okrelone na pat wierzchokw
//////////////////////////////////////////////////////////////////////
patch in vec3 b210;
patch in vec3 b120;
patch in vec3 b021;
patch in vec3 b012;
patch in vec3 b102;
patch in vec3 b201;
patch in vec3 b111;
patch in vec3 n110;
patch in vec3 n011;
patch in vec3 n101;

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchokw trjkta
//////////////////////////////////////////////////////////////////////
#define b300 In[0].position.xyz
#define b030 In[1].position.xyz
#define b003 In[2].position.xyz

//////////////////////////////////////////////////////////////////////
// wsprzdne wektorw normalnych wierzchokw
//////////////////////////////////////////////////////////////////////
#define n200 In[0].normal
#define n020 In[1].normal
#define n002 In[2].normal

//////////////////////////////////////////////////////////////////////
// blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec3 position;

    // wsprzdne wektora normalnego
    vec3 normal;
} Out;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // wsprzdne barycentryczne wierzchoka prymitywu
    float u = gl_TessCoord[0];
    float v = gl_TessCoord[1];
    float w = gl_TessCoord[2];   // w = 1 - u - v;

    // interpolacja szecienna wsprzdnych wierzchoka
    Out.position = b300 * w * w * w +
                   b030 * u * u * u +
                   b003 * v * v * v +
                   b210 * 3.0 * w * w * u +
                   b120 * 3.0 * w * u * u +
                   b201 * 3.0 * w * w * v +
                   b021 * 3.0 * u * u * v +
                   b102 * 3.0 * w * v * v +
                   b012 * 3.0 * u * v * v +
                   b111 * 6.0 * w * u * v;

    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * vec4( Out.position, 1.0 );

    // interpolacja kwadratowa wektora normalnego
    Out.normal = normalize( n200 * w * w + n020 * u * u + n002 * v * v +
                            n110 * w * u + n011 * u * v + n101 * w * v );
}
