//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// prototypy funkcji
//////////////////////////////////////////////////////////////////////
vec4 BlinnPhongLight( const int light, const vec3 normal, const vec3 position,
                      const vec4 ambient, const vec4 diffuse,
                      const vec4 specular, const float shininess );

//////////////////////////////////////////////////////////////////////
// kolory poszczeglnych instancji obiektu
//////////////////////////////////////////////////////////////////////
const vec4 colors[5] = vec4[5]
(
    vec4( 1.0, 0.0, 0.0, 1.0 ),     // czerwony
    vec4( 0.0, 1.0, 0.0, 1.0 ),     // zielony
    vec4( 0.0, 0.0, 1.0, 1.0 ),     // niebieski
    vec4( 1.0, 1.0, 0.0, 1.0 ),     // ty
    vec4( 1.0, 0.0, 1.0, 1.0 )      // rowy
);

//////////////////////////////////////////////////////////////////////
// blok zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec3 position;

    // wsprzdne wektora normalnego
    vec3 normal;

    // numer obiektu
    flat int object;
} In;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

//////////////////////////////////////////////////////////////////////
// wyjciowy numer renderowanego obiektu
//////////////////////////////////////////////////////////////////////
out int outObject;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // normalizacja wektora normalnego zalena od strony wielokta
    vec3 normal = gl_FrontFacing ? normalize( In.normal ) : -normalize( In.normal );

    // kolor fragmentu
    outColor = colors[In.object] * BlinnPhongLight( 0, normal, In.position, 
                    vec4( 0.2, 0.2, 0.2, 1.0 ), vec4( 0.8, 0.8, 0.8, 1.0 ), vec4( 0.5, 0.5, 0.5, 1.0 ), 5.0 );

    // numer obiektu (inkrementacja z uwagi
    // na to, e numer 0 oznacza to)
    outObject = In.object + 1;
}
