//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// wektory przesunicia pooenia poszczeglnych czajnikw
//////////////////////////////////////////////////////////////////////
const vec4 positions[4] = vec4[4]
(
    vec4( -3.0, -3.0,  0.0,  0.0 ),
    vec4( -1.0, -1.0, -1.33, 0.0 ),
    vec4( 1.0,  1.0, -2.66, 0.0 ),
    vec4( 3.0,  3.0, -4.0,  0.0 )
);

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0
#define NORMAL 1

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
layout( location = NORMAL ) in vec3 inNormal;

//////////////////////////////////////////////////////////////////////
// blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;

    // numer materiau
    int material;
} Out;

void main()
{
    // wsprzdne wierzchoka
    Out.position = inPosition + positions[gl_InstanceID];

    // wsprzdne wektora normalnego
    Out.normal = inNormal;

    // numer materiau
    Out.material = gl_InstanceID + 1;
}
