//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.50
//////////////////////////////////////////////////////////////////////
#version 450

//////////////////////////////////////////////////////////////////////
// opcjonalne wczenie obsugi rozszerzenia GL_ARB_cull_distance
//////////////////////////////////////////////////////////////////////
//#extension GL_ARB_cull_distance: require

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// wspczynniki rwnania paszczyzny usuwania
//////////////////////////////////////////////////////////////////////
const vec4 cullPlane = vec4( 1.0, 0.0, 0.0, 0.0 );

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// tablica z odlegociami od paszczyzn usuwania
//////////////////////////////////////////////////////////////////////
out float gl_CullDistance[1];

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // standardowe przeksztacenie wierzchokw
    gl_Position = modelViewProjectionMatrix * inPosition;

    // obliczenie odlegoci wierzchoka od paszczyzny usuwania
    gl_CullDistance[0] = dot( cullPlane, gl_Position );
}
