//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// macierz tekstury
//////////////////////////////////////////////////////////////////////
uniform mat4 textureMatrix;

//////////////////////////////////////////////////////////////////////
// wspczynniki rwna paszczyzn obcinania
//////////////////////////////////////////////////////////////////////
uniform vec4 clipPlane[1];

//////////////////////////////////////////////////////////////////////
// tablica z odlegociami od paszczyzn obcinania
//////////////////////////////////////////////////////////////////////
out float gl_ClipDistance[1];

//////////////////////////////////////////////////////////////////////
// numery pooenia poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0
#define NORMAL   1

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
layout( location = NORMAL ) in vec3 inNormal;

//////////////////////////////////////////////////////////////////////
// interpolowany wektor normalny
//////////////////////////////////////////////////////////////////////
out vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
out vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
out vec4 inoutTexCoord;

void main()
{
    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * inPosition;

    // wsprzdne wierzchoka do interpolacji
    inoutPosition = inPosition.xyz;

    // wsprzdne wektora normalnego do interpolacji
    inoutNormal = inNormal;

    // wsprzdne tekstury cienia
    inoutTexCoord = textureMatrix * inPosition;

    // obliczenie odlegoci wierzchoka od paszczyzny obcinania
    // macierz modelu widoku jest w tym przypadku (pokj)
    // macierz jednostkow, std nie musimy dokonywa mnoenia
    gl_ClipDistance[0] = dot( clipPlane[0], inPosition );
}
