//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// prymityw wejciowy
//////////////////////////////////////////////////////////////////////
layout( points ) in;

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw prymitywu wejciowego i wyjciowego
//////////////////////////////////////////////////////////////////////
#define MAX_VERTICES 4

//////////////////////////////////////////////////////////////////////
// prymityw wyjciowy (dwa trjkty)
//////////////////////////////////////////////////////////////////////
layout( triangle_strip, max_vertices = MAX_VERTICES ) out;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// rozmiar punktu
//////////////////////////////////////////////////////////////////////
uniform float pointSize;

//////////////////////////////////////////////////////////////////////
// tablica offsetw wsprzdnych wierzchokw prostokta
//////////////////////////////////////////////////////////////////////
vec4 pointOffset[MAX_VERTICES] = vec4[MAX_VERTICES]
(
    vec4( -0.0075 * pointSize, 0.0075 * pointSize, 0.0, 0.0 ),
    vec4( -0.0075 * pointSize, -0.0075 * pointSize, 0.0, 0.0 ),
    vec4( 0.0075 * pointSize, 0.0075 * pointSize, 0.0, 0.0 ),
    vec4( 0.0075 * pointSize, -0.0075 * pointSize, 0.0, 0.0 )
);

//////////////////////////////////////////////////////////////////////
// tablica wsprzdnych tekstury wierzchokw prostokta
//////////////////////////////////////////////////////////////////////
vec2 texCoords[MAX_VERTICES] = vec2[MAX_VERTICES]
(
    vec2( 0.0, 1.0 ),
    vec2( 0.0, 0.0 ),
    vec2( 1.0, 1.0 ),
    vec2( 1.0, 0.0 )
);

//////////////////////////////////////////////////////////////////////
// wejciowe wsprzdne punktu i numer patka niegu
//////////////////////////////////////////////////////////////////////
in vec4 inoutPosition[1];

//////////////////////////////////////////////////////////////////////
// wyjciowe wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
out vec2 texCoord;

//////////////////////////////////////////////////////////////////////
// numer tekstury patka niegu
//////////////////////////////////////////////////////////////////////
flat out float snowFlake;

void main()
{
    // generowanie wierzchokw
    for( int v = 0; v < MAX_VERTICES; v++ )
    {
        gl_Position = modelViewProjectionMatrix * (vec4( inoutPosition[0].xyz, 1.0 ) + pointOffset[v] );
        texCoord = texCoords[v];
        snowFlake = inoutPosition[0].w;
        EmitVertex();
    }

    // koniec prymitywu
    EndPrimitive();
}
