//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.10
//////////////////////////////////////////////////////////////////////
#version 410

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw prymitywu wejciowego i wyjciowego
//////////////////////////////////////////////////////////////////////
#define MAX_VERTICES 3

//////////////////////////////////////////////////////////////////////
// prymityw wejciowy
//////////////////////////////////////////////////////////////////////
layout( triangles ) in;

//////////////////////////////////////////////////////////////////////
// prymityw wyjciowy
//////////////////////////////////////////////////////////////////////
layout( triangle_strip, max_vertices = MAX_VERTICES ) out;

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    vec4 color;     // kolor wierzchoka
} In[MAX_VERTICES];

//////////////////////////////////////////////////////////////////////
// blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    vec4 color;     // kolor wierzchoka do interpolacji
} Out;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main ()
{
    // generowanie kolejnych wierzchokw prymitywu
    for( int v = 0; v < gl_in.length(); v++ )
    {
        // numer obszaru renderingu
        gl_ViewportIndex = 1;

        // atrybuty wierzchoka
        gl_Position = gl_in[v].gl_Position;
        Out.color = In[v].color;
        EmitVertex();
    }

    // koniec prymitywu
    EndPrimitive();
}
