//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLenum textureWrapS;
extern GLenum textureWrapT;

//////////////////////////////////////////////////////////////////////
// nazwa pliku podana w wierszu polecenia
//////////////////////////////////////////////////////////////////////
extern char *fileName;

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // zawijanie tekstury w kierunku wsprzdnej S
    WRAP_S_GL_REPEAT,
    WRAP_S_GL_CLAMP_TO_BORDER,
    WRAP_S_GL_MIRRORED_REPEAT,
    WRAP_S_GL_CLAMP_TO_EDGE,
    WRAP_S_GL_MIRROR_CLAMP_TO_EDGE,

    // zawijanie tekstury w kierunku wsprzdnej T
    WRAP_T_GL_REPEAT,
    WRAP_T_GL_CLAMP_TO_BORDER,
    WRAP_T_GL_MIRRORED_REPEAT,
    WRAP_T_GL_CLAMP_TO_EDGE,
    WRAP_T_GL_MIRROR_CLAMP_TO_EDGE,
    EXIT    // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // zawijanie tekstury w kierunku wsprzdnej S
        case WRAP_S_GL_REPEAT:
            textureWrapS = GL_REPEAT;
            break;
        case WRAP_S_GL_CLAMP_TO_BORDER:
            textureWrapS = GL_CLAMP_TO_BORDER;
            break;
        case WRAP_S_GL_MIRRORED_REPEAT:
            textureWrapS = GL_MIRRORED_REPEAT;
            break;
        case WRAP_S_GL_CLAMP_TO_EDGE:
            textureWrapS = GL_CLAMP_TO_EDGE;
            break;
        case WRAP_S_GL_MIRROR_CLAMP_TO_EDGE:
            textureWrapS = GL_MIRROR_CLAMP_TO_EDGE;
            break;

        // zawijanie tekstury w kierunku wsprzdnej T
        case WRAP_T_GL_REPEAT:
            textureWrapT = GL_REPEAT;
            break;
        case WRAP_T_GL_CLAMP_TO_BORDER:
            textureWrapT = GL_CLAMP_TO_BORDER;
            break;
        case WRAP_T_GL_MIRRORED_REPEAT:
            textureWrapT = GL_MIRRORED_REPEAT;
            break;
        case WRAP_T_GL_CLAMP_TO_EDGE:
            textureWrapT = GL_CLAMP_TO_EDGE;
            break;
        case WRAP_T_GL_MIRROR_CLAMP_TO_EDGE:
            textureWrapT = GL_MIRROR_CLAMP_TO_EDGE;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // pobranie nazwy pliku do wywietlenia
    fileName = argv[1];

    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 3, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
    glutCreateWindow( "Zawijanie tekstury 2D" );

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_3_3 )
    {
        std::cout << "Brak OpenGL 3.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu - GL_TEXTURE_WRAP_S
    int menuWrapS = glutCreateMenu( Menu );
    glutAddMenuEntry( "GL_REPEAT", WRAP_S_GL_REPEAT );
    glutAddMenuEntry( "GL_CLAMP_TO_BORDER", WRAP_S_GL_CLAMP_TO_BORDER );
    glutAddMenuEntry( "GL_MIRRORED_REPEAT", WRAP_S_GL_MIRRORED_REPEAT );
    glutAddMenuEntry( "GL_CLAMP_TO_EDGE", WRAP_S_GL_CLAMP_TO_EDGE );
    glutAddMenuEntry( "GL_MIRROR_CLAMP_TO_EDGE", WRAP_S_GL_MIRROR_CLAMP_TO_EDGE );

    // utworzenie podmenu - GL_TEXTURE_WRAP_T
    int menuWrapT = glutCreateMenu( Menu );
    glutAddMenuEntry( "GL_REPEAT", WRAP_T_GL_REPEAT );
    glutAddMenuEntry( "GL_CLAMP_TO_BORDER", WRAP_T_GL_CLAMP_TO_BORDER );
    glutAddMenuEntry( "GL_MIRRORED_REPEAT", WRAP_T_GL_MIRRORED_REPEAT );
    glutAddMenuEntry( "GL_CLAMP_TO_EDGE", WRAP_T_GL_CLAMP_TO_EDGE );
    glutAddMenuEntry( "GL_MIRROR_CLAMP_TO_EDGE", WRAP_T_GL_MIRROR_CLAMP_TO_EDGE );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddSubMenu( "GL_TEXTURE_WRAP_S", menuWrapS );
    glutAddSubMenu( "GL_TEXTURE_WRAP_T", menuWrapT );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
