//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.30
//////////////////////////////////////////////////////////////////////
#version 430

//////////////////////////////////////////////////////////////////////
// liczba wierzchokw w wyjciowym pacie wierzchokw
//////////////////////////////////////////////////////////////////////
layout( vertices = 3 ) out;

//////////////////////////////////////////////////////////////////////
// definicje numerw pooenia zmiennych jednorodnych
// i powizania uchwytw tekstur
//////////////////////////////////////////////////////////////////////
#define AMBIENT     0
#define DIFFUSE     1
#define SPECULAR    2
#define SHININESS   3
#define HEIGHT      4
#define NORMAL      5
#define TEXTURE_LOC 4

//////////////////////////////////////////////////////////////////////
// tablica znacznikw materiaw zawartych w teksturze
//////////////////////////////////////////////////////////////////////
layout( location = TEXTURE_LOC ) uniform bool textures[6] =
        bool[6]( false, false, false, false, false, false );

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;

    // wsprzdne wektora stycznego
    vec3 tangent;

    // wsprzdne wektora bistycznego
    vec3 bitangent;

    // wsprzdne tekstury
    vec2 texCoord;
} In[];

//////////////////////////////////////////////////////////////////////
// tablica blokw zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;

    // wsprzdne wektora stycznego
    vec3 tangent;

    // wsprzdne wektora bistycznego
    vec3 bitangent;

    // wsprzdne tekstury
    vec2 texCoord;
} Out[];

//////////////////////////////////////////////////////////////////////
// wewntrzny i zewntrzny poziom teselacji
//////////////////////////////////////////////////////////////////////
uniform float tessLevel = gl_MaxTessGenLevel;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // parametry teselacji zapisywane tylko w pierwszym wywoaniu shadera
    if( gl_InvocationID == 0 )
    {
        // test dostpnoci mapy wysokoci
        if( textures[HEIGHT] )
        {
            gl_TessLevelOuter[0] = tessLevel;
            gl_TessLevelOuter[1] = tessLevel;
            gl_TessLevelOuter[2] = tessLevel;
            gl_TessLevelInner[0] = tessLevel;
        }
        
        // brak mapy wysokoci - brak teselacji
        else
        {
            gl_TessLevelOuter[0] = 1.0;
            gl_TessLevelOuter[1] = 1.0;
            gl_TessLevelOuter[2] = 1.0;
            gl_TessLevelInner[0] = 1.0;
        }
    }

    // wsprzdne wierzchoka
    Out[gl_InvocationID].position = In[gl_InvocationID].position;

    // wsprzdne wektora normalnego
    Out[gl_InvocationID].normal = In[gl_InvocationID].normal;

    // wsprzdne wektora stycznego
    Out[gl_InvocationID].tangent = In[gl_InvocationID].tangent;

    // wsprzdne wektora bistycznego
    Out[gl_InvocationID].bitangent = In[gl_InvocationID].bitangent;

    // wsprzdne tekstury
    Out[gl_InvocationID].texCoord = In[gl_InvocationID].texCoord;
}
