//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>
#include <materials.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat left;
extern GLfloat right;
extern GLfloat bottom;
extern GLfloat top;
extern GLfloat scale;
extern GLfloat rotateX;
extern GLfloat rotateY;
extern GLfloat translateX;
extern GLfloat translateY;
extern GLfloat rotateLightX;
extern GLfloat rotateLightY;
extern int material;
extern int object;

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// pooenie kursora myszy
//////////////////////////////////////////////////////////////////////
int buttonX, buttonY;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // zapamitanie pooenia kursora myszy
        if( state == GLUT_DOWN )
        {
            buttonX = x;
            buttonY = y;
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        rotateY += 30 *(right - left) / glutGet( GLUT_WINDOW_WIDTH ) * (x - buttonX);
        buttonX = x;
        rotateX -= 30 *(top - bottom) / glutGet( GLUT_WINDOW_HEIGHT ) * (buttonY - y);
        buttonY = y;
        glutPostRedisplay();
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // klawisz +
        case '+':
            scale += 0.03f;
            break;
        // klawisz -
        case '-':
            if( scale > 0.03f ) scale -= 0.03f;
            break;
        // 1
        case '1':
            object = 0;
            break;
        // 2
        case '2':
            object = 1;
            break;
        // 3
        case '3':
            object = 2;
            break;
        // q
        case 'Q':
        case 'q':
            rotateLightX += 1.0f;
            break;
        // a
        case 'A':
        case 'a':
            rotateLightX -= 1.0f;
            break;
        // w
        case 'W':
        case 'w':
            rotateLightY += 1.0f;
            break;
        // s
        case 'S':
        case 's':
            rotateLightY -= 1.0f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiszy funkcyjnych i klawiszy kursora
//////////////////////////////////////////////////////////////////////
void SpecialKeys( int key, int x, int y )
{
    switch( key )
    {
        // kursor w lewo
        case GLUT_KEY_LEFT:
            translateX -= 0.03f;
            break;

        // kursor w gr
        case GLUT_KEY_UP:
            translateY += 0.03f;
            break;

        // kursor w prawo
        case GLUT_KEY_RIGHT:
            translateX += 0.03f;
            break;

        // kursor w d
        case GLUT_KEY_DOWN:
            translateY -= 0.03f;
            break;

        // nastpny materia
        case GLUT_KEY_PAGE_DOWN:
            if( material < MTL_YELLOW_RUBBER )
                material = material + 1;
            else
                material = MTL_DEFAULT;
            break;

        // poprzedni materia
        case GLUT_KEY_PAGE_UP:
            if( material > MTL_DEFAULT )
                material = material - 1;
            else
                material = MTL_YELLOW_RUBBER;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    // rodzaj obiektu
    TEAPOT,
    TEACUP,
    TEASPOON,

    EXIT       // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // rodzaj obiektu
        case TEAPOT:
        case TEACUP:
        case TEASPOON:
            object = value;
            break;

        // materia
        case MTL_DEFAULT + 10:              // materia domylny
        case MTL_BRASS + 10:                // mosidz
        case MTL_BRONZE + 10:               // brz
        case MTL_POLISHED_BRONZE + 10:      // polerowany brz
        case MTL_CHROME + 10:               // chrom
        case MTL_COPPER + 10:               // mied
        case MTL_POLISHED_COPPER + 10:      // polerowana mied
        case MTL_GOLD + 10:                 // zoto
        case MTL_POLISHED_GOLD + 10:        // polerowane zoto
        case MTL_PEWTER + 10:               // grafit (cyna z oowiem)
        case MTL_SILVER + 10:               // srebro
        case MTL_POLISHED_SILVER + 10:      // polerowane srebro
        case MTL_EMERALD + 10:              // szmaragd
        case MTL_JADE + 10:                 // jadeit
        case MTL_OBSIDIAN + 10:             // obsydian
        case MTL_PEARL + 10:                // pera
        case MTL_RUBY + 10:                 // rubin
        case MTL_TURQUOISE + 10:            // turkus
        case MTL_BRIGHT_WHITE + 10:         // jasny biay
        case MTL_LESS_BRIGHT_WHITE + 10:    // mniej jasny biay
        case MTL_WARMISH_WHITE + 10:        // ciepy biay
        case MTL_COOLISH_WHITE + 10:        // zimny biay
        case MTL_BLACK_PLASTIC + 10:        // czarny plastik
        case MTL_CYAN_PLASTIC + 10:         // niebieskozielony plastik
        case MTL_GREEN_PLASTIC + 10:        // zielony plastik
        case MTL_RED_PLASTIC + 10:          // czerwony plastik
        case MTL_WHITE_PLASTIC + 10:        // biay plastik
        case MTL_YELLOW_PLASTIC + 10:       // ty plastik
        case MTL_BLACK_RUBBER + 10:         // czarna guma
        case MTL_CYAN_RUBBER + 10:          // niebieskozielona guma
        case MTL_GREEN_RUBBER + 10:         // zielona guma
        case MTL_RED_RUBBER + 10:           // czerwona guma
        case MTL_WHITE_RUBBER + 10:         // biaa guma
        case MTL_YELLOW_RUBBER + 10:        // ta guma
            material = value - 10;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 4, 2 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
#ifdef WIN32
    glutCreateWindow( "Powierzchnia Bziera" );
#else
    glutCreateWindow( "Powierzchnia Beziera" );
#endif // WIN32

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_4_2 )
    {
        std::cout << "Brak OpenGL 4.2" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu "Materia"
    int menuMaterial = glutCreateMenu( Menu );
    glutAddMenuEntry( "default", MTL_DEFAULT + 10 );
    glutAddMenuEntry( "Brass", MTL_BRASS + 10 );
    glutAddMenuEntry( "Bronze", MTL_BRONZE + 10 );
    glutAddMenuEntry( "Polished Bronze", MTL_POLISHED_BRONZE + 10 );
    glutAddMenuEntry( "Chrome", MTL_CHROME + 10 );
    glutAddMenuEntry( "Copper", MTL_COPPER + 10 );
    glutAddMenuEntry( "Polished Copper", MTL_POLISHED_COPPER + 10 );
    glutAddMenuEntry( "Gold", MTL_GOLD + 10 );
    glutAddMenuEntry( "Polished Gold", MTL_POLISHED_GOLD + 10 );
    glutAddMenuEntry( "Pewter", MTL_PEWTER + 10 );
    glutAddMenuEntry( "Silver", MTL_SILVER + 10 );
    glutAddMenuEntry( "Polished Silver", MTL_POLISHED_SILVER + 10 );
    glutAddMenuEntry( "Emerald", MTL_EMERALD + 10 );
    glutAddMenuEntry( "Jade", MTL_JADE + 10 );
    glutAddMenuEntry( "Obsidian", MTL_OBSIDIAN + 10 );
    glutAddMenuEntry( "Pearl", MTL_PEARL + 10 );
    glutAddMenuEntry( "Ruby", MTL_RUBY + 10 );
    glutAddMenuEntry( "Turquoise", MTL_TURQUOISE + 10 );
    glutAddMenuEntry( "Bright White", MTL_BRIGHT_WHITE + 10 );
    glutAddMenuEntry( "Less Bright White", MTL_LESS_BRIGHT_WHITE + 10 );
    glutAddMenuEntry( "Warmish White", MTL_WARMISH_WHITE + 10 );
    glutAddMenuEntry( "Coolish White", MTL_COOLISH_WHITE + 10 );
    glutAddMenuEntry( "Black Plastic", MTL_BLACK_PLASTIC + 10 );
    glutAddMenuEntry( "Cyan Plastic", MTL_CYAN_PLASTIC + 10 );
    glutAddMenuEntry( "Green Plastic", MTL_GREEN_PLASTIC + 10 );
    glutAddMenuEntry( "Red Plastic", MTL_RED_PLASTIC + 10 );
    glutAddMenuEntry( "White Plastic", MTL_WHITE_PLASTIC + 10 );
    glutAddMenuEntry( "Yellow Plastic", MTL_YELLOW_PLASTIC + 10 );
    glutAddMenuEntry( "Black Rubber", MTL_BLACK_RUBBER + 10 );
    glutAddMenuEntry( "Cyan Rubber", MTL_CYAN_RUBBER + 10 );
    glutAddMenuEntry( "Green Rubber", MTL_GREEN_RUBBER + 10 );
    glutAddMenuEntry( "Red Rubber", MTL_RED_RUBBER + 10 );
    glutAddMenuEntry( "White Rubber", MTL_WHITE_RUBBER + 10 );
    glutAddMenuEntry( "Yellow Rubber", MTL_YELLOW_RUBBER + 10 );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddMenuEntry( "Czajnik ", TEAPOT );
    glutAddMenuEntry( "Filizanka", TEACUP );
    glutAddMenuEntry( "Lyzeczka", TEASPOON );
    glutAddSubMenu( "Material", menuMaterial );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // obsuga klawiszy funkcyjnych i klawiszy kursora
    glutSpecialFunc( SpecialKeys );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
