//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// wektory przesuni poszczeglnych instancji obiektu
//////////////////////////////////////////////////////////////////////
const vec4 positions[14] = vec4[14]
(
    // pierwszy rzd
    vec4( 1.4, 0.0, 4.0, 0.0 ),
    vec4( -1.1, 0.0, 4.1, 0.0 ),

    // drugi rzd
    vec4( 0.1, 0.0, 2.0, 0.0 ),
    vec4( 2.5, 0.0, 1.9, 0.0 ),
    vec4( -2.4, 0.0, 2.1, 0.0 ),

    // trzeci rzd
    vec4( 1.1, 0.0, 0.1, 0.0 ),
    vec4( 3.5, 0.0, 0.0, 0.0 ),
    vec4( -1.2, 0.0, -0.1, 0.0 ),
    vec4( -3.6, 0.0, 0.1, 0.0 ),

    // czwarty rzd
    vec4( 0.1, 0.0, -2.0, 0.0 ),
    vec4( 2.4, 0.0, -1.8, 0.0 ),
    vec4( -2.5, 0.0, -2.1, 0.0 ),

    // pity rzd
    vec4( -1.4, 0.0, -4.0, 0.0 ),
    vec4( 1.1, 0.0, -4.1, 0.0 )
);

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0
#define TEX_COORD 1

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
layout( location = TEX_COORD ) in vec2 inTexCoord;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
out vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * (inPosition + positions[gl_InstanceID]);

    // interpolacja wsprzdnych tekstury
    inoutTexCoord = inTexCoord;
}
