//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// macierz tekstury
//////////////////////////////////////////////////////////////////////
uniform mat4 textureMatrix;

//////////////////////////////////////////////////////////////////////
// liczba instancji
//////////////////////////////////////////////////////////////////////
uniform float instCount;

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION  0
#define TEX_COORD 1

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
layout( location = TEX_COORD ) in vec3 inTexCoord;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
out vec3 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // numer warstwy tekstury
    float layer = gl_InstanceID/( instCount - 1.0 );

    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * vec4( inPosition.x, inPosition.y, inPosition.z + 2.0 * layer, inPosition.w );

    // transformacja i rotacja wsprzdnych tekstury
    vec4 texCoord = vec4( inTexCoord.x, inTexCoord.y + layer, inTexCoord.z, 0.0 );
    texCoord -= vec4( 0.5, 0.5, 0.5, 0.0 );
    texCoord = textureMatrix * texCoord;
    texCoord += vec4( 0.5, 0.5, 0.5, 0.0 );

    // interpolacja wsprzdnych tekstury
    inoutTexCoord = texCoord.xyz;
}
