#version 420 core

layout (location = 0) in vec4 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec3 tangent;
// Cho pliku modelu z tego przykadu zawiera dwustyczn,
// nie uyjemy jej i obliczymy wasn na podstawie
// normalnej i stycznej.
// layout (location = 3) in vec3 bitangent;
layout (location = 4) in vec2 texcoord;

out VS_OUT
{
    vec2 texcoord;
    vec3 eyeDir;
    vec3 lightDir;
    vec3 normal;
} vs_out;

uniform mat4 mv_matrix;
uniform mat4 proj_matrix;
uniform vec3 light_pos = vec3(0.0, 0.0, 100.0);

void main(void)
{
	// Oblicz pooenie wierzchoka w przestrzeni widoku.
    vec4 P = mv_matrix * position;

    // Oblicz wektor normalny (N) i styczny (T) w przestrzeni widoku
    // na podstawie wektorw z przestrzeni obiektu.
    vec3 N = normalize(mat3(mv_matrix) * normal);
    vec3 T = normalize(mat3(mv_matrix) * tangent);
    // Oblicz wektor dwustyczny (B) na podstawie normalnej i wektora stycznej.
    vec3 B = cross(N, T);

    // Wektor wiata (L) to wektor od analizowanego punktu do wiata.
    // Oblicz go i pomn przez macierz TBN.
    vec3 L = light_pos - P.xyz;
    vs_out.lightDir = normalize(vec3(dot(V, T), dot(V, B), dot(V, N)));

    // Wektor widoku to wektor od analizowanego punktu do widza (kamery),
    // wic to po prostu negacja aktualnego pooenia.
    // Oblicz go i pomn przez macierz TBN.
    vec3 V = -P.xyz;
    vs_out.eyeDir = normalize(vec3(dot(V, T), dot(V, B), dot(V, N)));

    // Przeka wsprzdne tekstury w postaci niezmodyfikowanej, aby shader
    // fragmentw mg pobra normalne i mapy kolorw.
    vs_out.texcoord = texcoord;

    // Przeka normalne dla wierzchokw, aby mona byo atwo wcza
	// lub wycza map normalnych.
    vs_out.normal = N;

    // Oblicz wsprzdne dla przycicia, mnoc aktualne pooenie 
    // przez macierz rzutowania.
    gl_Position = proj_matrix * P;
}
