#version 410 core

uniform sampler2D tex_envmap;

in VS_OUT
{
    vec3 normal;
    vec3 view;
} fs_in;

out vec4 color;

void main(void)
{
    // Zmienna u to znormalizowany wektor widoku.
    vec3 u = normalize(fs_in.view);

    // Odbij u względem płaszczyzny zdefiniowanej przez normalną w miejscu fragmentu.
    vec3 r = reflect(u, normalize(fs_in.normal));

    // Oblicz współczynnik skalowania.
    r.z += 1.0;
    float m = 0.5 * inversesqrt(dot(r, r));

    // Próbka na podstawie przesuniętej i przeskalowanej współrzędnej tekstury.
    color = texture(tex_envmap, r.xy * m + vec2(0.5));
}
