#version 440 core

#extension GL_ARB_shader_draw_parameters : require

// Wejścia dla każdego wierzchołka.
layout (location = 0) in vec4 position;
layout (location = 1) in vec3 normal;
layout (location = 4) in vec2 tc;

// Potrzebne macierze.
layout (std140, binding = 0) uniform MATRIX_BLOCK
{
#if 0
    mat4 view_matrix;
    mat4 proj_matrix;
    mat4 model_matrix[384];
#else
    mat4 model_matrix[386];
#endif
};

// 

// Wyjścia z shadera wierzchołków.
out VS_OUT
{
    vec3 N;
    vec3 L;
    vec3 V;
    vec2 tc;
    flat uint instance_index;
} vs_out;

// Położenie światła.
const vec3 light_pos = vec3(100.0, 100.0, 100.0);

void main(void)
{
#if 1
    mat4 view_matrix = model_matrix[0];
    mat4 proj_matrix = model_matrix[1];
#endif

    mat4 mv_matrix = view_matrix * model_matrix[gl_InstanceID + 2];
    // mat4 proj_matrix = proj_matrix;

    // Oblicz współrzędne w przestrzeni widoku.
    vec4 P = mv_matrix * position;

    // Oblicz normalne w przestrzeni widoku.
    vs_out.N = mat3(mv_matrix) * normal;

    // Oblicz wektor światła.
    vs_out.L = light_pos - P.xyz;

    // Oblicz wektor widoku.
    vs_out.V = -P.xyz;

    // Przekaż współrzędne tekstury dalej.
    vs_out.tc = tc * vec2(5.0, 1.0);

    // Przekaż identyfikator instancji.
    vs_out.instance_index = gl_InstanceID;

    // Oblicz położenie w przestrzeni przycięcia dla każdego wierzchołka.
    gl_Position = proj_matrix * P;
}
