#version 420 core

uniform mat4 mv_matrix;
uniform mat4 proj_matrix;

layout (location = 0) in vec4 position;
layout (location = 1) in vec3 normal;

out VS_OUT
{
    vec3 N;
    vec3 L;
    vec3 V;
} vs_out;

// Position of light
uniform vec3 light_pos = vec3(100.0, 100.0, 100.0);

void main(void)
{
    // Oblicz współrzędne w przestrzeni widoku.
    vec4 P = mv_matrix * position;

    // Oblicz normalne w przestrzeni widoku.
    vs_out.N = mat3(mv_matrix) * normal;

    // Oblicz wektor światła.
    vs_out.L = light_pos - P.xyz;

    // Oblicz wektor widoku.
    vs_out.V = -P.xyz;

    // Oblicz położenie w przestrzeni przycięcia dla każdego wierzchołka.
    gl_Position = proj_matrix * P;
}
