#version 430 core

// Licznik niepodzielny dla wypełnionego rozmiaru.
layout (binding = 0, offset = 0) uniform atomic_uint fill_counter;

// Dwuwymiarowy obraz przechowujący wskaźniki głowy.
layout (binding = 0, r32ui) coherent uniform uimage2D head_pointer;

// Bufor magazynowy shadera przechowujący dołączone fragmenty.
struct list_item
{
    vec4        color;
    float       depth;
    int         facing;
    uint        next;
};

layout (binding = 0, std430) buffer list_item_block
{
    list_item   item[];
};

// Wyjście z shadera wierzchołków.
in VS_OUT
{
    vec4 pos;
    vec4 color;
} fs_in;

void main(void)
{
    ivec2 P = ivec2(gl_FragCoord.xy);

    uint index = atomicCounterIncrement(fill_counter);

    uint old_head = imageAtomicExchange(head_pointer, P, index);

    item[index].color = fs_in.color;
    item[index].depth = gl_FragCoord.z;
    item[index].facing = gl_FrontFacing ? 1 : 0;
    item[index].next = old_head;
}
