// Listing 19.2. Obliczanie macierzy fundamentalnej metod RANSAC
#include <opencv2/opencv.hpp>
#include <iostream>

using namespace std;
void help(char *argv[]) { 
	cout 	<< "\nListing 19.2. Obliczanie macierzy fundamentalnej metod RANSAC. Pokazanie kamerze szachownicy "
			<< "\nWywoanie"
			<< "\n./example_19-2 <1:board_w> <2:board_h> <3: liczba plansz> <4:liczba ms midzy klatkami> <5:skala obrazw 0-1>"
			<< "\n\nPrzykadowe wywoanie:"
			<< "\n./example_19-2 9 6 20 500 0.5"
			<< "\n\n -- uyj dostarczonego pliku checkerboard9x6.png"
			<< "\n" 
			<< endl;
}


// argumnety: [board_w] [board_h] [number_of_boards] [delay]? [scale]?
//
int main(int argc, char *argv[]) {
  int n_boards = 0;
  float image_sf = 0.5f;
  float delay = 1.f;
  int board_w = 0;
  int board_h = 0;

  // ustawiane przez list wejciow
  if (argc != 6) {
    cout << "\nBD: nieprawidowa liczba parametrw wejciowych, powinno by, otrzymano " << argc - 1 << "\n";
    help(argv);
    return -1;
  }
  board_w = atoi(argv[1]);
  board_h = atoi(argv[2]);
  n_boards = atoi(argv[3]);
  delay = atof(argv[4]);
  image_sf = atof(argv[5]);
  int board_n = board_w * board_h;
  cv::Size board_sz = cv::Size(board_w, board_h);
  cv::VideoCapture capture(0);

  if (!capture.isOpened()) {
    cout << "\nNie udao si otworzy kamery\n";
    help(argv);
    return -1;
  }
  // alokacja pamici
  //
  vector<vector<cv::Point2f> > image_points;
  vector<vector<cv::Point3f> > object_points;
  // chwytanie widokw; ptla powtarza si, a znajdzie n_boards poprawnych widokw
  // (czyli takich, w ktrych plansza zawiera wszystkie rogi)
  //
  double last_captured_timestamp = 0;
  cv::Size image_size;
  while (image_points.size() < (size_t)n_boards) {
    cv::Mat image0, image;
    capture >> image0;
    image_size = image0.size();
    resize(image0, image, cv::Size(), image_sf, image_sf, cv::INTER_LINEAR);
	// szukanie planszy
    //
    vector<cv::Point2f> corners;
    bool found = cv::findChessboardCorners(image, board_sz, corners);
	// rysowanie planszy
    //
    cv::drawChessboardCorners(image, board_sz, corners, found);
	// jeli plansza jest dobra, dodajemy j do swoich danych
    //
    double timestamp = (double)clock() / CLOCKS_PER_SEC;
    if (found && timestamp - last_captured_timestamp > 1) {
      last_captured_timestamp = timestamp;
      image ^= cv::Scalar::all(255);

      cv::Mat mcorners(corners);
	  // nie kopiuje danych
      mcorners *= (1. / image_sf);
	  // skaluje wsprzdne rogw
      image_points.push_back(corners);
      object_points.push_back(vector<cv::Point3f>());
      vector<cv::Point3f> &opts = object_points.back();
      opts.resize(board_n);
      for (int j = 0; j < board_n; j++) {
        opts[j] = cv::Point3f((float)(j / board_w), (float)(j % board_w), 0.f);
      }
	  cout << "Zgromadzilimy " << (int)image_points.size()
		  << " z " << n_boards << " potrzebnych obrazw szachownicy.\n" << endl;
    }
	// kolorowanie, jeli pobralimy obraz
    //
    cv::imshow("Calibration", image);
    if ((cv::waitKey(30) & 255) == 27)
      return -1;
  }
  // koniec ptli while() gromadzenia obrazw
  cv::destroyWindow("Calibration");
  cout << "\n\n*** Kalibracja kamery...\n" << endl;
  // Kalibracja kamery!
  //
  cv::Mat intrinsic_matrix, distortion_coeffs;
  double err = cv::calibrateCamera(
	  object_points,     // wektor wektorw punktw z wzoru kalibracji
	  image_points,      // wektor wektorw rzutowanych lokalizacji (na obrazach)
	  image_size,        // rozmiar uytych obrazw
	  intrinsic_matrix,  // wyjciowa macierz kamery
	  distortion_coeffs, // wyjciowe wspczynniki znieksztace
	  cv::noArray(),     // przekaemy wektory rotacji
	  cv::noArray(),     // i translacji
	  cv::CALIB_ZERO_TANGENT_DIST | cv::CALIB_FIX_PRINCIPAL_POINT
  );


  // zapisanie parametrw wewntrznych i znieksztace
  cout << " *** GOTOWE!\n\nBdy reprojekcji zapisano w plikach " << err
	  << "\nStoring Intrinsics.xml i Distortions.xml.\n\n";
  cv::FileStorage fs("intrinsics.xml", cv::FileStorage::WRITE);

  fs << "image_width" << image_size.width << "image_height"
	  << image_size.height << "camera_matrix" << intrinsic_matrix
	  << "distortion_coefficients" << distortion_coeffs;
  fs.release();

  // przykad wczytania tych macierzy z powrotem:
  //
  fs.open("intrinsics.xml", cv::FileStorage::READ);
  cout << "\nszeroko obrazu: " << (int)fs["image_width"];
  cout << "\nwysoko obrazu: " << (int)fs["image_height"];

  cv::Mat intrinsic_matrix_loaded, distortion_coeffs_loaded;
  fs["camera_matrix"] >> intrinsic_matrix_loaded;
  fs["distortion_coefficients"] >> distortion_coeffs_loaded;
  cout << "\nmacierz wewntrzna:" << intrinsic_matrix_loaded;
  cout << "\nwspczynniki znieksztace: " << distortion_coeffs_loaded
	  << endl;

  // obliczenie macierzy fundamentalnej midzy pierwsz i drug klatk:
  //
  cv::undistortPoints(
	  image_points[0],   // wsprzdne obserwowanego punktu (z klatki 0)
	  image_points[0],   // wsprzdne po likwidacji znieksztace (w tym przypadku ta sama tablica co powyej)
	  intrinsic_matrix,  // parametry wewntrzne z cv::calibrateCamera()
	  distortion_coeffs, // wspczynniki znieksztace, take z cv::calibrateCamera()
	  cv::Mat(),         // rektyfikacja (ale w tym przypadku jej nie potrzebujemy)
	  intrinsic_matrix   // nowa macierz kamery
  );
  cv::undistortPoints(
	  image_points[1],   // wsprzdne obserwowanego punktu (z klatki 1)
	  image_points[1],   // wsprzdne po likwidacji znieksztace (w tym przypadku ta sama tablica co powyej)
	  intrinsic_matrix,  // parametry wewntrzne z cv::calibrateCamera()
	  distortion_coeffs, // wspczynniki znieksztace, take z cv::calibrateCamera()
	  cv::Mat(),         // rektyfikacja (ale w tym przypadku jej nie potrzebujemy)
	  intrinsic_matrix   // nowa macierz kamery
  );

  // poniewa wszystkie znalezione rogi szachownicy to punkty bliskie, tzn.
  // musz spenia warunki epipolarne, posugujemy si najszybszym
  // i najdokadniejszym (w tym przypadku) algorytmem 8-punktowym
  //
  cv::Mat F = cv::findFundamentalMat( // zwraca obliczon macierz
	  image_points[0],                  // punkty z klatki 0
	  image_points[1],                  // punkty z klatki 1
	  cv::FM_8POINT                     // wczenie algorytmu 8-punktowego
  );
  cout << "Macierz fundamentalna: " << F << endl;

  // budowa matrycy likwidacji znieksztace, ktra zostanie zastosowana do wszystkich nastpnych klatek
  //
  cv::Mat map1, map2;
  cv::initUndistortRectifyMap(
	  intrinsic_matrix_loaded,  // nasza macierz kamery
	  distortion_coeffs_loaded, // nasze wspczynniki znieksztace
	  cv::Mat(),                // (opcjonalne) rektyfikacja niepotrzebna
	  intrinsic_matrix_loaded,  // nowa macierz, tu jest taka sama jak w pierwszym argumencie
	  image_size,               // rozmiar obrazu po likwidacji znieksztace
	  CV_16SC2,                 // format matrycy
	  map1,                     // wsprzdne zamienione na cakowitoliczbowe
	  map2                      // staoprzecinkowe przesunicia
								// elementw matrycy of map1
  );
  // wywietlenie obrazu nieprzetworzonego i obrazu poprawionego
  //
  for (;;) {
	  cv::Mat image, image0;
	  capture >> image0;
	  if (image0.empty()) break;
	  cv::remap(
		  image0, // obraz wejciowy
		  image,  // obraz wyjciowy
		  map1,   // cakowitoliczbowa cz matrycy
		  map2,   // staoprzecinkowa cz matrycy
		  cv::INTER_LINEAR,
		  cv::BORDER_CONSTANT,
		  cv::Scalar() // koloruje wartoci graniczne na czarno
	  );
	  cv::imshow("Undistorted", image);
	  if ((cv::waitKey(30) & 255) == 27) break;
  }
  return 1;
}
