// Listing 15.1. Odczytanie wartoci RGB wszystkich pikseli znajdujcych si w jednym rzdzie w filmie i zapisanie ich w trzech osobnych plikach
//
#include <opencv2/opencv.hpp>
#include <iostream>
#include <fstream>

using namespace std;

void help(char** argv ) {
	cout << "\n"
		<< "Listing 15.1: Wczytuje wartoci RGB pikseli i zapisuje je na dysku\nWywoanie:\n"
		<< argv[0] <<" <path/video_file>\n"
		<< "\nPrzykad:\n" << argv[0] << " ../tree.avi"
		<< "\n Wartoci zostan zapisane w plikach blines.csv, glines.csv i rlines.csv.\n\n"
		<< endl;
}

int main( int argc, char** argv) {
	// obsuga argumentw
	//
	if(argc != 2) { help(argv); return -1; }
	cv::namedWindow( argv[0], CV_WINDOW_AUTOSIZE );
	cv::VideoCapture cap;
	if((argc < 2)|| !cap.open(argv[1]))
	{
		cerr << "Nie udao si otworzy pliku wideo" << endl;
		help(argv);
		cap.open(0);
		return -1;
	}
	
	// przygotowanie wynikw
	//
	cv::Point pt1(10,10), pt2(30,30);
	int max_buffer;
	cv::Mat rawImage;
	ofstream b,g,r;
	b.open("blines.csv");
	g.open("glines.csv");
	r.open("rlines.csv");

	// GWNA PTLA PRZETWARZANIA:
	//
	for(;;) {
		cap >> rawImage;
		if( !rawImage.data ) break;
		cv::LineIterator it( rawImage, pt1, pt2, 8);
		for( int j=0; j<it.count; ++j,++it ) {
			b << (int)(*it)[0] << ", ";
			g << (int)(*it)[1] << ", ";
			r << (int)(*it)[2] << ", ";
			(*it)[2] = 255;   // oznacz t prbk na czerwono
		}
		cv::imshow( argv[0], rawImage );
		int c = cv::waitKey(10);
		b << "\n"; g << "\n"; r << "\n";
	}

	// SPRZTANIE
	//
	b << endl; g << endl; r << endl;
	b.close(); g.close(); r.close();
	cout << "\n"
		<< "Dane zapisane w plikach blines.csv, glines.csv i rlines.csv\n\n"
		<< endl;
}
