// Listing 8.3. Odczyt pliku .yml przy uyciu obiektu cv::FileStorage
//
#include <opencv2/opencv.hpp>

using namespace std;

int main(int argc, char** argv) {
  cout << "\nListing 8.3. Odczyt pliku .yml przy uyciu obiektu cv::FileStorage"
       << "\nWywoanie:\n"
       << argv[0] << endl;
  
  cv::FileStorage fs2("test.yml", cv::FileStorage::READ);

  // pierwsza metoda: uycie operatora (typ) w odniesieniu do FileNode
  //
  int frameCount = (int)fs2["frameCount"];

  // druga metoda: uycie operatora cv::FileNode::operator >>
  //
  std::string date;
  fs2["calibrationDate"] >> date;

  cv::Mat cameraMatrix2, distCoeffs2;
  fs2["cameraMatrix"] >> cameraMatrix2;
  fs2["distCoeffs"] >> distCoeffs2;

  cout << "liczba klatek: "        << frameCount    << endl
       << "data kalibracja: "  << date          << endl
       << "macierz kamery: "     << cameraMatrix2 << endl
       << "wspczynniki znieksztace: " << distCoeffs2   << endl;

  cv::FileNode features = fs2["features"];
  cv::FileNodeIterator it = features.begin(), it_end = features.end();
  int idx = 0;
  std::vector<uchar> lbpval;

  // iteracja przez sekwencj za pomoc iteratora FileNodeIterator
  for( ; it != it_end; ++it, idx++ ) {

    cout << "feature #" << idx << ": ";
    cout << "x="   << (int)(*it)["x"]
         << ", y=" << (int)(*it)["y"]
         << ", lbp: (";

	// (Uwaga: tablice liczbowe mona atwo odczytywa za pomoc FileNode >> std::vector)
    //
    (*it)["lbp"] >> lbpval;
    for( int i = 0; i < (int)lbpval.size(); i++ )
      cout << " " << (int)lbpval[i];
    cout << ")" << endl;

  }

  fs2.release();

}
