// Listing 2.9. Pobieranie i ustawianie pikseli z przykadu 2.8

#include <opencv2/opencv.hpp>

void help(char** argv ) {
	std::cout << "\n"
	<< "\nListing 2.9. Pobieranie i ustawianie pikseli z listingu 2.8."
    << "\nWywoanie:\n"  
	<< argv[0] <<" <path/image>\n"
	<< "Na przykad:\n"
	<< argv[0] << " ../fruits.jpg\n"
	<< std::endl;
}
	

int main( int argc, char** argv ) {
	
	if (argc != 2) {
		help(argv);
		return 0;
	}


  cv::Mat img_rgb, img_gry, img_cny, img_pyr, img_pyr2;

  cv::namedWindow( "Example Gray", cv::WINDOW_AUTOSIZE );
  cv::namedWindow( "Example Canny", cv::WINDOW_AUTOSIZE );

  img_rgb = cv::imread( argv[1] );

  cv::cvtColor( img_rgb, img_gry, cv::COLOR_BGR2GRAY);

  cv::pyrDown( img_gry, img_pyr );
  cv::pyrDown( img_pyr, img_pyr2 );

  cv::Canny( img_pyr2, img_cny, 10, 100, 3, true );

  // ----------------------------------------------------
  // nowy kod z listingu 2.9
  //

  int x = 16, y = 32;
  cv::Vec3b intensity = img_rgb.at< cv::Vec3b >(y, x);

  // ( Uwaga: mona napisa write img_rgb.at< cv::Vec3b >(x,y)[0] )
  //
  uchar blue  = intensity[0];
  uchar green = intensity[1];
  uchar red   = intensity[2];

  std::cout << "W punkcie (x,y) = (" << x << ", " << y <<
    "): (blue, green, red) = (" <<
    (unsigned int)  blue <<
    ", " << (unsigned int)green << ", " <<
    (unsigned int)  red << ")" << std::endl;

  std::cout << "Szary piksel: " <<
    (unsigned int)  img_gry.at<uchar>(y, x) << std::endl;

  x /= 4; y /= 4;

  std::cout << "Piksel Pyramid2: " <<
    (unsigned int)img_pyr2.at<uchar>(y, x) << std::endl;

  img_cny.at<uchar>(x, y) = 128; // ustawienie piksela Canny'ego na 128

  //
  // koniec nowego kodu z listingu 2.9
  // ----------------------------------------------------

  cv::imshow( "Example Gray", img_gry );
  cv::imshow( "Example Canny", img_cny );

  cv::waitKey(0);

}
