// Listing 16.1. Przykad zastosowania piramidowego algorytmu przepywu optycznego L-K
//
#include <iostream>
#include <vector>
#include <opencv2/opencv.hpp>

static const int MAX_CORNERS = 1000;
using std::cout;
using std::endl;
using std::vector;


void help( char** argv ) {
  cout << "\nListing 16.1: Przykad zastosowania piramidowego algorytmu przepywu optycznego L-K.\n" << endl;
  cout << "Wywoanie: " <<argv[0] <<" [image1] [image2]\n" << endl;
  cout << "\nPrzykad:\n" << argv[0] << " ../example_16-01-imgA.png ../example_16-01-imgB.png\n" << endl;
  cout << "Demonstruje przykad zastosowania piramidowego algorytmu przepywu optycznego L-K.\n" << endl;
}

int main(int argc, char** argv) {
    if (argc != 3) {
        help(argv);
        exit(-1);
    }
	// inicjalizacja, zaadowanie dwch obrazw z systemu plikw oraz
	// alokacja obrazw i innych struktur, ktre bd potrzebne do zwrcenia wynikw
    //
    cv::Mat imgA = cv::imread(argv[1], CV_LOAD_IMAGE_GRAYSCALE);
    cv::Mat imgB = cv::imread(argv[2], CV_LOAD_IMAGE_GRAYSCALE);
    cv::Size img_sz = imgA.size();
    int win_size = 10;
    cv::Mat imgC = cv::imread(argv[2], CV_LOAD_IMAGE_UNCHANGED);
    // The first thing we need to do is get the features
    // we want to track.
    //
    vector< cv::Point2f > cornersA, cornersB;
    const int MAX_CORNERS = 500;
    cv::goodFeaturesToTrack(
		imgA,           // obraz do ledzenia
		cornersA,       // wektor wykrytych rogw (wyjciowy)
		MAX_CORNERS,    // chcemy tyle rogw
		0.01,           // poziom jakoci (procent wartoci maksymalnej)
		5,              // minimalna odlego midzy rogami
		cv::noArray(),  // maska
		3,              // rozmiar bloku
		false,          // true: Harris, false: Shi-Tomasi
		0.04            // parametr specyficzny dla metody
	);
	cv::cornerSubPix(
		imgA,           // obraz wejciowy
		cornersA,       // wektor rogw (wejcie i wyjcie)
		cv::Size(win_size, win_size), // poowa boku okienka poszukiwa
		cv::Size(-1, -1),              // poowa dugoci boku martwej strefy (-1=brak)
		cv::TermCriteria(
			cv::TermCriteria::MAX_ITER | cv::TermCriteria::EPS,
			20,   // maksymalna liczba iteracji
			0.03  // minimalna zmiana na iteracj
		)
	);

	// wywoanie algorytmu Lucasa-Kanade'a
	//

    vector<uchar> features_found;
    cv::calcOpticalFlowPyrLK(
		imgA, // poprzedni obraz
		imgB,           // nastpny obraz
		cornersA,       // poprzedni zbir rogw (z imgA)
		cornersB,       // nastpny zbir rogw (z imgB)
		features_found, // wektor wyjciowy, ledzone elementy s oznaczane 1
		noArray(),      // wektor wyjciowy, listy bdw (opcjonalny)
		cv::Size(win_size * 2 + 1, win_size * 2 + 1), // rozmiar okienka poszukiwa
		5,              // maksymalna liczba poziomw piramidy
		cv::TermCriteria(
			cv::TermCriteria::MAX_ITER | cv::TermCriteria::EPS,
			20,           // maksymalna liczba iteracji
			0.3           // minimalna zmiana na iteracj
		)
	);

	// tworzenie obrazu z tego, co przegldamy:
	// jeli chcesz dalej ledzi cornersB, tzn. przekaza te rogi na wejciu do kolejnego wywoania calcOpticalFlowPyrLK,
	// musisz skompresowa wektor, czyli usun punkty, dla ktrych
	// features_found[i] == false
    for (int i = 0; i < static_cast<int>(cornersA.size()); ++i) {
        if (!features_found[i]) {
            continue;
        }
        line(
            imgC,                        // rysuje na tym obrazie
            cornersA[i],                 // pocztek
            cornersB[i],                 // koniec
            cv::Scalar(0, 255, 0),       // ten kolor
            1,                           // tyle pikseli szerokoci
            cv::LINE_AA                  // rysuje lini w tym stylu
        );
    }

    cv::imshow("ImageA", imgA);
    cv::imshow("ImageB", imgB);
    cv::imshow("Przykad zastosowania piramidowego algorytmu przepywu optycznego L-K", imgC);
    cv::waitKey(0);

    return 0;
}
