// Listing 4.1. Sumowanie elementw tablicy wielowymiarowej paszczyzna po paszczynie
#include <opencv2/opencv.hpp>
#include <iostream>

using namespace std;

// Sumowanie elementw tablicy wielowymiarowej paszczyzna po paszczynie
//
int main( int argc, char** argv ) {
  
  cout << "\nListing 4.1. Sumowanie elementw tablicy wielowymiarowej paszczyzna po paszczynie"
       << "\nWywoanie:\n"
       << argv[0] << endl;

  const int n_mat_size = 5;
  const int n_mat_sz[] = { n_mat_size, n_mat_size, n_mat_size };
  cv::Mat n_mat( 3, n_mat_sz, CV_32FC1 );

  cv::RNG rng;
  rng.fill( n_mat, cv::RNG::UNIFORM, 0.f, 1.f );

  const cv::Mat* arrays[] = { &n_mat, 0 };
  cv::Mat my_planes[1];
  cv::NAryMatIterator it( arrays, my_planes );

  // w kadej iteracji it.planes[i] bdzie biec
  // paszczyzn i-tej tablicy z arrays
  //
  float s = 0.f; // suma wszystkich paszczyzn
  int   n = 0;   // liczba wszystkich paszczyzn
  for (int p = 0; p < it.nplanes; p++, ++it) {
    s += cv::sum(it.planes[0])[0];
    n++;
  }

  cout <<"Suma caoci: " <<s <<endl;

}
