// Listing 2.11. Kompletny program wczytujcy kolorowy film i zapisujcy na wyjciu
// film przeksztacony do formatu logarytmiczno-biegunowego.

#include <opencv2/opencv.hpp>
#include <iostream>


void help(char** argv ) {
	std::cout << "\n"
	<< "Wczytuje film, zwraca przeksztacenie do formatu logarytmiczno-biegunowego.\n"
	<< argv[0] <<" <path/video> <paht/video_output>\n"
	<< "Na przykad:\n"
	<< argv[0] << " ../tree.avi ../vout.avi\n"
	<< "\nWczytanie:\n ./example_02-10 ../vout.avi\n"
	<< std::endl;
}
	

int main( int argc, char** argv ) {
	
	if (argc != 3) {
		help(argv);
		return 0;
	}
		

  cv::namedWindow( "Listing 2.11", cv::WINDOW_AUTOSIZE );
  cv::namedWindow( "Log_Polar", cv::WINDOW_AUTOSIZE );

  // (Uwaga: mona pobiera dane z kamery, przekazujc jej identyfikator w postaci liczby cakowitej).
  //

  cv::VideoCapture capture( argv[1] );
  double fps = capture.get( CV_CAP_PROP_FPS );
  cv::Size size(
    (int)capture.get( CV_CAP_PROP_FRAME_WIDTH ),
    (int)capture.get( CV_CAP_PROP_FRAME_HEIGHT )
  );

  cv::VideoWriter writer;
  writer.open( argv[2], CV_FOURCC('M','J','P','G'), fps, size );

  cv::Mat logpolar_frame, bgr_frame;

  for(;;) {

    capture >> bgr_frame;
    if( bgr_frame.empty() ) break; // koniec, jeli gotowe

    cv::imshow( "Example 2-11", bgr_frame );

    cv::logPolar(
      bgr_frame, // kolorowa klatka wejciowa
      logpolar_frame, // wyjciowa klatka logarytmiczno-biegunowa
      cv::Point2f( // rodek transformacji logarytmiczno-biegunowej
        bgr_frame.cols/2, // x
        bgr_frame.rows/2 // y
      ),
      40, // rozmiar (parametr skali)
      CV_WARP_FILL_OUTLIERS // wypenienie wartoci odstajcych zerem
    );

    cv::imshow( "Log_Polar", logpolar_frame );

    writer << logpolar_frame;

    char c = cv::waitKey(10);

    if( c == 27 ) break; // umoliwienie uytkownikowi przerwania programu

  }

  writer.release();
  capture.release();

}
