// Listing 2.1. Prosty program OpenCV wczytujcy i wywietlajcy obraz z dysku
#include <opencv2/opencv.hpp>

void help(char** argv ) {
	std::cout << "\n"
	<< "Prosty program OpenCV wczytujcy i wywietlajcy obraz z dysku.\n"
	<< argv[0] <<" <path/filename>\n"
	<< "Na przykad:\n"
	<< argv[0] << " ../fruits.jpg\n"
	<< std::endl;
}
	

int main( int argc, char** argv ) {
	
	if (argc != 2) {
		help(argv);
		return 0;
	}
		

  cv::Mat img = cv::imread( argv[1], -1 );

  if( img.empty() ) return -1;

  cv::namedWindow( "Listing 2.1", cv::WINDOW_AUTOSIZE );
  cv::imshow( "Listing 2.1", img );
  cv::waitKey( 0 );
  cv::destroyWindow( "Listing 2.1" );

  return 0;
}
