// Listing 2.5. Wczytywanie i wygadzanie obrazu przed wywietleniem go na ekranie

#include <opencv2/opencv.hpp>



void help(char** argv ) {
	std::cout << "\n"
	<< "2.5: wczytuje i wygadza obraz, ktry nastpnie wywietla.\n"
	<< argv[0] <<" <path/video>\n"
	<< "Na przykad:\n"
	<< argv[0] << " ../tree.avi\n"
	<< std::endl;
}
	

int main( int argc, char** argv ) {
	
	if (argc != 2) {
		help(argv);
		return 0;
	}

  // Wczytuje obraz wskazany w wierszu polece.
  //
  cv::Mat image = cv::imread(argv[1],-1);

  // Tworzy okna, do prezentacji obrazw wejciowego
  // i wyjciowego.
  //
  cv::namedWindow( "Listing 2.5-wejcie", cv::WINDOW_AUTOSIZE );
  cv::namedWindow( "Listing 2.5-wyjcie", cv::WINDOW_AUTOSIZE );

  // tworzy okno do prezentacji obrazu wejciowego
  //
  cv::imshow( "Listing 2.5-wejcie", image );

  // tworzy obraz do przechowywania wygadzonego wyniku
  //
  cv::Mat out;

  // wygadzanie
  // (Uwaga: mona uy GaussianBlur(), blur(), medianBlur() lub
  // bilateralFilter(). )
  //
  cv::GaussianBlur( image, out, cv::Size(5,5), 3, 3);
  cv::GaussianBlur( out, out, cv::Size(5,5), 3, 3);

  // wywietlenie wygadzonego obrazu w oknie wyjciowym
  //
  cv::imshow( "Listing  2.5-wyjcie", out );

  // gdy uytkownik nacinie jaki klawisz, okna ulegn autodestrukcji
  //
  cv::waitKey( 0 );

}
