// Listing 10.3. Staa warto progowa a adaptacyjna warto progowa
#include <opencv2/opencv.hpp>
#include <cstdlib>
#include <iostream>

using namespace std;

int main( int argc, char** argv )
{
	if(argc != 7) { cout << "\nListing 10.3. Staa warto progowa a adaptacyjna warto progowa.\n"
		"Sposb uycia: " << argv[0] << " fixed_threshold invert(0=off|1=on) "
		"adaptive_type(0=mean|1=gaussian) block_size offset image\n"
		"Przykad: " << argv[0] << " 100 1 0 15 10 fruits.jpg\n"; return -1;
	}


	// przetwarzanie argumentw wiersza polece
	//
	double fixed_threshold = (double)atof(argv[1]);
	int threshold_type = atoi(argv[2]) ? cv::THRESH_BINARY : cv::THRESH_BINARY_INV;
	int adaptive_method = atoi(argv[3]) ? cv::ADAPTIVE_THRESH_MEAN_C
	: cv::ADAPTIVE_THRESH_GAUSSIAN_C;
	int block_size = atoi(argv[4]);
	double offset = (double)atof(argv[5]);
	cv::Mat Igray = cv::imread(argv[6], cv::IMREAD_GRAYSCALE);

	// wczytuje szary obraz
	//
	if( Igray.empty() ){ cout << "NIe udao si wczyta obrazu " << argv[6] << endl; return -1; }

	// deklaracja obrazw wyjciowych
	//
	cv::Mat It, Iat;

	// progi
	//
	cv::threshold(
		Igray,
		It,
		fixed_threshold,
		255,
		threshold_type);
	cv::adaptiveThreshold(
		Igray,
		Iat,
		255,
		adaptive_method,
		threshold_type,
		block_size,
		offset
		);
		
	// Show the results.
	//
	cv::imshow("Raw",Igray);
	cv::imshow("Threshold",It);
	cv::imshow("Adaptive Threshold",Iat);
	cv::waitKey(0);
	return 0;
}
