// Listing 10.1. Sumowanie trzech kanaw obrazu za pomoc funkcji cv::threshold()

#include <opencv2/opencv.hpp>
#include <iostream>

using namespace std;

void sum_rgb( const cv::Mat& src, cv::Mat& dst ) {

	// dzieli obraz na paszczyzny kolorw
	//
	vector< cv::Mat> planes;
	cv::split(src, planes);
	cv::Mat b = planes[0], g = planes[1], r = planes[2], s;

	// dodaje jednakowo waone wartoci rgb
	//
	cv::addWeighted( r, 1./3., g, 1./3., 0.0, s );
	cv::addWeighted( s, 1., b, 1./3., 0.0, s );

	// obcina wartoci powyej 100
	//
	cv::threshold( s, dst, 100, 100, cv::THRESH_TRUNC );
}

void help(char ** argv) {
	cout << "\nListing 10.1. Sumowanie trzech kanaw obrazu za pomoc funkcji cv::threshold().\n" << endl;
	cout << "Wywoanie:\n" << argv[0] << " ../faces.jpg" << endl;
}

int main(int argc, char** argv) {
	help(argv);
	if(argc < 2) { cout << "\nOkrel obraz wejciowy" << endl; return -1; }

	// aduje obraz z okrelonego pliku
	//
	cv::Mat src = cv::imread( argv[1] ), dst;
	if( src.empty() ) { cout << "Nie udao si zaadowa obrazu " << argv[1] << endl; return -1; }
	sum_rgb( src, dst);

	// tworzy okno o takiej samej nazwie jak nazwa pliku i wywietla w nim obraz
	//
	cv::imshow( argv[1], dst );

	// czeka bezczynnie, a uytkownik nacinie jakikolwiek klawisz
	//
	cv::waitKey(0);
	return 0;
}
