 // Misja w nadprzestrzeń C++14/17, program z paragrafu   3.10


#include <iostream>
#include <string>
using namespace std;
//*******************************************************************
template <typename T>		// szablon funkcji							// `1
auto podziel(T a, T b)
{
	if constexpr (std::is_pointer<T>( ) ) 									// `2
	{
		// mam podzielić coś, co jest wskazywane wskaźnikami
		return (*a) / (*b); 		// ta składnia jest możliwa dla wskaźników.
							// (dla wartości – składnia (*a) jest niedopuszczalna).
	}
	else { 															// `3
		// mam podzielić zwykłe wartości
		return a / b;			// dzielenie jest możliwe dla wartości (arytmetycznych).
							// (dla wskaźników – operator dzielenia jest niedopuszczalny).
	}
}
//*******************************************************************
int main()
{
	double wynik;
	wynik = podziel(24.0, 8.0) ;											// `4
	cout << " Wynik (24.0 / 8.0) = " << wynik << endl;

	double x = 600;
	double y = 16;
	double *wsk1 = &x;
	double *wsk2 = &y;
	wynik = podziel(wsk1, wsk2);  										// `5

	cout << "Podzielenie dwoch wartosci wskazanych dwoma wskaznikami\n wynik = "
		<< wynik << endl;
}
