 // Misja w nadprzestrzeń C++14/17, program z paragrafu 3.2

#include <iostream>
using namespace std;
const int ile = 10;
/////////////////////////////////////////////////////////////////////////////////////////
class Tklasa		 													// `1
{
	int n;
	int *wsk; 															// `2
public:
	Tklasa ( int arg ) : n ( arg ), wsk ( new int[ile] ) 							// `3
	{
		for ( int i = 0; i < ile; ++i )
			wsk[i] = i*n; 												// `4
	}
	//---------------------------------
	~Tklasa() 			// destruktor 									// `5
	{
		cout << "Destruktor k" << n << endl;
		delete [ ] wsk;
		wsk = nullptr;
	}
	//---------------------------------
	// nie musi być tego konstruktora kopiującego, ale ...
	Tklasa ( Tklasa &k ) : n(k.n), wsk (k.wsk)	 							// `6
	{
		cout << "DZIALA KONSTRUKTOR KOPIUJACY" << endl;
	 	k.wsk = nullptr;
	}
	//---------------------------------
	void pokaz(string txt ) 												// `7
	{
		cout << txt << " n= " << n << ", tablica = " ;
		for ( int i = 0; i < ile; ++i ) cout << wsk[i] << " ";
		cout << endl;
	}
};
//*******************************************************************
// zwykła globalna funkcja zwracająca nowy chwilowy obiekt
Tklasa fabryka (int numerek )											// `8
{
	cout << "W funkcji fabryka produkujemy obiekt chwilowy k" << numerek << endl;
	Tklasa chwilowy (numerek);		 // obiekt chwilowy (nie volatile!)
	return chwilowy; 													// `9
}
//*******************************************************************
int main()
{
	Tklasa k1 ( 1 ); 													// `10
	k1.pokaz("k1: ");

	// w tych inicjalizacjach nie musi działać konstruktor kopiujący
	Tklasa k2 = Tklasa(2); 												// `11
	k2.pokaz("k2: ");

	Tklasa k3 {Tklasa(3)} ;	 											// `12
	k3.pokaz("k3: ");

	fabryka (44); 		// <---  zwrot rezultatu przez wartość odbył się bez kopiowania 	// `13
	cout << "Powyzszy rezultat zaniedbalismy" << endl;

	Tklasa k5 = fabryka ( 5 );			// inicjalizacja obiektu rezultatem funkcji 	// `14
	k5.pokaz("k5: ");

	try {
		cout << "W bloku try" << endl;
		// poniżej jest inicjalizacja rzucanego obiektu wyjątku
		// 			za pomocą obiektu chwilowego typu Tklasa
	 	throw Tklasa(6);						 						// `15
	}
	catch (Tklasa & kexep) 	// tu nie trzeba lecącego obiektu kopiować,  		// `16
						// bo zostaje on złapany przez referencję
	{
		kexep.pokaz("Referencja do obiektu, ktory przylecial:\n");				// `17
	}
	cout << "Po blokach try, catch ------------" << endl;

	cout << "Koniec funkcji main -------------------" << endl;
}
