 // Misja w nadprzestrzeń C++14/17, program z paragrafu   3.10.1

#include <iostream>
#include <string>
using namespace std;
//*******************************************************************
template<typename T>
std::false_type 	czy_lubiany_typ;										// `1
//*******************************************************************
template< >
std::true_type  	czy_lubiany_typ<const char*> ;							// `2
//*******************************************************************
template< >
std::true_type  	czy_lubiany_typ<std::string>;							// `3
//*******************************************************************
template <typename T>
void funkcja_robocza(T arg)							// szablon funkcji 		// `4
{
	cout << "Czy ten typ T jest aprobowany? ";
	// if constexpr nazwa_zmiennej_szablonowej)
	if constexpr (czy_lubiany_typ<T> ) 									// `5
	{
		cout << "TAK" << endl;											// `6
		std::string tekst (arg);
		cout << "\tTekst: >" << tekst << "<, \n\ta litera nr [2] to '" << arg[2] << "'"<< endl; // `7
	}
	else {
		cout << "NIE" << endl;											// `8
		T tmp = arg;
		cout << "\tWydruk nie-tekstowego arg = " << tmp << endl;
	}
}
//*******************************************************************
int main()
{
	cout << "Proba z liczba typu T ---> int \n";
	funkcja_robocza(5);												// `9

	cout << "\nProba z C-stringiem (typ const char*) \n";
	funkcja_robocza("abc"); 											// `10

	cout << "\nProba z obj. kl. std::string \n";
	string s("Nowosci w C++17");
	funkcja_robocza(s) ;												// `11

	cout << "\nProba ze wskaznikiem int * \n";
	int roboczy = 4;
	int *wsk = &roboczy;
	funkcja_robocza(wsk);												// `12
}
