 // Misja w nadprzestrzeń C++14/17, program z paragrafu 2.5.1



 // `@
#include <iostream>
#include <string>
using namespace std;
//*******************************************************************849]>
// sposób  1.  pi zrealizowane jako szablon funkcji
template<typename T>
T pi1() { return 3.1415926535897932385; }								 // `1

/////////////////////////////////////////////////////////////////////////////////////////3853]>
// sposób  2a.  pi za pomocą szablonu klasy ze składnikiem statycznym
// umieszczonym poza ciałem klasy.
template<typename T>
struct  pi2a															 // `2
{
		static T  wartosc;  // patrz. Opus, str. 572 (tom I)
};
// na zewnątrz szablonu klasy musi wystąpić definicja tego składnika
template<typename T>
T pi2a<T>::wartosc = 3.1415926535897932385;							 // `3

/////////////////////////////////////////////////////////////////////////////////////////3853]>
// sposób  2b.  pi zrealizowane jako szablon klasy (struktury) ze składnikiem statycznym
// inicjalizowanym „w klasie”.
template<typename T>
struct  pi2b															 // `4
{
		static constexpr T  wartosc = 3.1415926535897932385;
};

//*******************************************************************854]>
// sposób 3., najlepszy: za pomocą szablonu zmiennej.  (C++14)
template <typename T>
T pi = T(3.1415926535897932385);										 // `5

//*******************************************************************856]>
// szablon funkcji, w którym z pi musimy korzystać
template<typename T>													 // `6
void fun(T arg)
{
	cout << "Obliczenia w funkcji szablonowej \n";
	T wynikA = arg * pi1<T>() ;											 // `7
	cout << "\tSposobem 1. \tWynikA to " << wynikA << endl;

	T wynikB = arg * pi2a<T>::wartosc; 									 // `8
	cout << "\tSposobem 2a. \tWynikB to " << wynikB << endl;

	T wynikC = arg * pi2b<T>::wartosc; 									 // `9
	cout << "\tSposobem 2b. \tWynikC to " << wynikC << endl;

	T wynikD = arg * pi<T>;												 // `10
	cout << "\tSposobem 3. \tWynikD to " << wynikD << endl;
}
//*******************************************************************857]>
int main()
{
	fun(1.0);					// fun<double>							 // `11
	fun(1.0f);   				// fun<float>   							 // `12
	fun(1);					// fun<int>								 // `13
}
